/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.cache;

import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class SimpleLRUCache<K, V>
extends ConcurrentHashMap<K, V> {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int MINIMUM_QUEUE_SIZE = 128;
    private final AtomicBoolean eviction = new AtomicBoolean();
    private final ReadWriteLock swapLock = new ReentrantReadWriteLock();
    private final int maximumCacheSize;
    private final AtomicReference<Deque<Map.Entry<K, V>>> lastChanges = new AtomicReference(new ConcurrentLinkedDeque());
    private final Consumer<V> evict;

    public SimpleLRUCache(int initialCapacity, int maximumCacheSize, Consumer<V> evicted) {
        super(initialCapacity, 0.75f);
        if (maximumCacheSize <= 0) {
            throw new IllegalArgumentException("The maximum cache size must be greater than 0");
        }
        this.maximumCacheSize = maximumCacheSize;
        this.evict = Objects.requireNonNull(evicted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V addChange(OperationContext<K, V> context, Function<? super K, ? extends V> mappingFunction) {
        Object key = context.key;
        V value = mappingFunction.apply(key);
        if (value == null) {
            return null;
        }
        Map.Entry entry = Map.entry(key, value);
        this.swapLock.readLock().lock();
        try {
            this.lastChanges.get().add(entry);
        }
        finally {
            this.swapLock.readLock().unlock();
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            super.compute(key, (k, v) -> {
                context.result = v;
                return this.addChange(context, x -> value);
            });
            Object v2 = context.result;
            return v2;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            super.compute(key, (k, v) -> {
                context.result = v;
                if (v != null) {
                    return v;
                }
                return this.addChange(context, x -> value);
            });
            Object v2 = context.result;
            return v2;
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        if (key == null || mappingFunction == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            Object object = super.computeIfAbsent(key, k -> this.addChange(context, mappingFunction));
            return (V)object;
        }
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            Object object = super.computeIfPresent(key, (k, v) -> this.addChange(context, x -> remappingFunction.apply((Object)x, (Object)v)));
            return (V)object;
        }
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        if (key == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            Object object = super.compute(key, (k, v) -> this.addChange(context, x -> remappingFunction.apply((Object)x, (Object)v)));
            return (V)object;
        }
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        if (key == null || value == null || remappingFunction == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            Object object = super.compute(key, (k, oldValue) -> {
                Object newValue = oldValue == null ? value : remappingFunction.apply((V)oldValue, (V)value);
                return this.addChange(context, x -> newValue);
            });
            return (V)object;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            super.computeIfPresent(key, (k, v) -> {
                if (Objects.equals(oldValue, v)) {
                    context.result = this.addChange(context, x -> newValue);
                    return context.result;
                }
                return v;
            });
            boolean bl = context.result != null && Objects.equals(context.result, newValue);
            return bl;
        }
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        try (OperationContext context = new OperationContext(this, key);){
            super.computeIfPresent(key, (k, v) -> {
                context.result = v;
                return this.addChange(context, x -> value);
            });
            Object v2 = context.result;
            return v2;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        for (Map.Entry<K, V> e : this.entrySet()) {
            this.replace(e.getKey(), e.getValue(), function.apply(e.getKey(), e.getValue()));
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    int getQueueSize() {
        return this.lastChanges.get().size();
    }

    private boolean evictionNeeded() {
        return this.isCacheFull() || this.isQueueFull();
    }

    private boolean isCacheFull() {
        return this.size() > this.maximumCacheSize;
    }

    private boolean isQueueFull() {
        return this.getQueueSize() > Math.max(2 * this.maximumCacheSize, 128);
    }

    private Map.Entry<K, V> nextOldestChange() {
        return this.lastChanges.get().poll();
    }

    private void compressChanges() {
        Map.Entry entry;
        Deque currentChanges;
        ConcurrentLinkedDeque<Map.Entry> newChanges = new ConcurrentLinkedDeque<Map.Entry>();
        this.swapLock.writeLock().lock();
        try {
            currentChanges = this.lastChanges.getAndSet(newChanges);
        }
        finally {
            this.swapLock.writeLock().unlock();
        }
        HashSet keys = new HashSet();
        while ((entry = (Map.Entry)currentChanges.pollLast()) != null) {
            if (!keys.add(entry.getKey())) continue;
            newChanges.addFirst(entry);
        }
    }

    private static class OperationContext<K, V>
    implements AutoCloseable {
        V result;
        final K key;
        private final SimpleLRUCache<K, V> cache;

        OperationContext(SimpleLRUCache<K, V> cache, K key) {
            this.cache = cache;
            this.key = key;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() {
            if (!this.cache.evictionNeeded() || !this.cache.eviction.compareAndSet(false, true)) return;
            try {
                do {
                    this.cache.compressChanges();
                    if (!this.cache.isCacheFull()) return;
                    Map.Entry<K, V> oldest = this.cache.nextOldestChange();
                    if (oldest == null || !this.cache.remove(oldest.getKey(), oldest.getValue())) continue;
                    this.cache.evict.accept(oldest.getValue());
                } while (this.cache.evictionNeeded());
                return;
            }
            finally {
                this.cache.eviction.set(false);
            }
        }
    }
}

