/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed RouteOnDemandReloadStrategy")
public class RouteOnDemandReloadStrategy
extends RouteWatcherReloadStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(RouteOnDemandReloadStrategy.class);

    public RouteOnDemandReloadStrategy() {
        this.setScheduler(false);
    }

    public RouteOnDemandReloadStrategy(String directory) {
        super(directory);
        this.setScheduler(false);
    }

    public RouteOnDemandReloadStrategy(String directory, boolean recursive) {
        super(directory, recursive);
        this.setScheduler(false);
    }

    @ManagedOperation(description="Trigger on-demand reloading")
    public void onReload() {
        this.onReload("JMX Management");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReload(Object source) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.setLastError(null);
            ClassLoader acl = this.getCamelContext().getApplicationContextClassLoader();
            if (acl != null) {
                Thread.currentThread().setContextClassLoader(acl);
            }
            this.doOnReload(source);
            this.incSucceededCounter();
        }
        catch (Exception e) {
            this.setLastError(e);
            this.incFailedCounter();
            LOG.warn("Error reloading routes due to {}. This exception is ignored.", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    protected void doOnReload(Object source) throws Exception {
        ArrayList<Resource> properties = new ArrayList<Resource>();
        ArrayList<Resource> groovy = new ArrayList<Resource>();
        ArrayList<Resource> routes = new ArrayList<Resource>();
        for (Resource resource : this.findReloadedResources(source)) {
            String string = FileUtil.onlyExt((String)resource.getLocation());
            if ("properties".equals(string)) {
                properties.add(resource);
                continue;
            }
            if ("groovy".equals(string)) {
                groovy.add(resource);
                continue;
            }
            routes.add(resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("On-demand reload scanned {} files (properties: {}, routes: {}, groovy: {})", new Object[]{properties.size() + routes.size(), properties.size(), routes.size(), groovy.size()});
        }
        boolean reloaded = false;
        for (Resource resource : properties) {
            reloaded |= this.onPropertiesReload(resource, false);
        }
        for (Resource resource : groovy) {
            reloaded |= this.onGroovyReload(resource, false);
        }
        boolean bl = this.isRemoveEverything(routes);
        if (reloaded || !routes.isEmpty()) {
            this.onRouteReload(routes, bl);
        } else {
            this.onRemoveEverything(bl);
        }
    }

    protected boolean isRemoveEverything(List<Resource> routes) {
        return routes.isEmpty();
    }

    protected void onRemoveEverything(boolean removeEverything) {
        this.onRouteReload(null, removeEverything);
    }

    protected List<Resource> findReloadedResources(Object source) throws Exception {
        ArrayList<Resource> answer = new ArrayList<Resource>();
        File dir = new File(this.getFolder());
        for (Path path : ResourceHelper.findInFileSystem(dir.toPath(), this.getPattern())) {
            Resource res = ResourceHelper.resolveResource(this.getCamelContext(), "file:" + path.toString());
            answer.add(res);
        }
        return answer;
    }
}

