/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stream;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.stream.StreamComponentException;
import org.apache.camel.component.stream.StreamExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamProducer
extends DefaultProducer<StreamExchange> {
    private static final Log LOG = LogFactory.getLog(StreamProducer.class);
    private static final String TYPES = "in,out,err,file,url,header";
    private static final String INVALID_URI = "Invalid uri, valid form: 'stream:{in,out,err,file,url,header}'";
    private static final List<String> TYPES_LIST = Arrays.asList("in,out,err,file,url,header".split(","));
    protected OutputStream outputStream = System.out;
    private String uri;
    private Map<String, String> parameters;

    public StreamProducer(Endpoint<StreamExchange> endpoint, String uri, Map<String, String> parameters) throws Exception {
        super(endpoint);
        this.parameters = parameters;
        this.validateUri(uri);
        LOG.debug((Object)"Stream producer created");
    }

    public void process(Exchange exchange) throws Exception {
        if (this.parameters.get("delay") != null) {
            long ms = Long.valueOf(this.parameters.get("delay"));
            this.delay(ms);
        }
        if ("out".equals(this.uri)) {
            this.outputStream = System.out;
        } else if ("err".equals(this.uri)) {
            this.outputStream = System.err;
        } else if ("file".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromFile();
        } else if ("header".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromHeader(exchange.getIn().getHeader("stream"));
        } else if ("url".equals(this.uri)) {
            this.outputStream = this.resolveStreamFromUrl();
        }
        this.writeToStream(exchange);
    }

    private OutputStream resolveStreamFromUrl() throws IOException {
        String u = this.parameters.get("url");
        URL url = new URL(u);
        URLConnection c = url.openConnection();
        return c.getOutputStream();
    }

    private OutputStream resolveStreamFromFile() throws IOException {
        String fileName = this.parameters.get("file");
        fileName = fileName != null ? fileName.trim() : "_file";
        File f = new File(fileName);
        LOG.debug((Object)("About to write to file: " + f));
        f.createNewFile();
        return new FileOutputStream(f);
    }

    private OutputStream resolveStreamFromHeader(Object o) throws StreamComponentException {
        if (o != null && o instanceof OutputStream) {
            return (OutputStream)o;
        }
        throw new StreamComponentException("Expected OutputStream in header('stream'), found: " + o);
    }

    private void delay(long ms) throws InterruptedException {
        LOG.debug((Object)("Delaying " + ms + " milliseconds"));
        Thread.sleep(ms);
    }

    private void writeToStream(Exchange exchange) throws IOException {
        Object body = exchange.getIn().getBody();
        LOG.debug((Object)("Writing " + body + " to " + this.outputStream));
        if (body instanceof String) {
            LOG.debug((Object)"in text buffered mode");
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(this.outputStream));
            bw.write((String)body + "\n");
            bw.flush();
        } else {
            LOG.debug((Object)"in binary stream mode");
            this.outputStream.write((byte[])body);
        }
    }

    private void validateUri(String uri) throws Exception {
        String[] s = uri.split(":");
        if (s.length < 2) {
            throw new Exception(INVALID_URI);
        }
        String[] t = s[1].split("\\?");
        if (t.length < 1) {
            throw new Exception(INVALID_URI);
        }
        this.uri = t[0].trim();
        if (!TYPES_LIST.contains(this.uri)) {
            throw new Exception(INVALID_URI);
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }
}

