/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stomp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.stomp.StompEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.fusesource.hawtbuf.AsciiBuffer;

public class StompConsumer
extends DefaultConsumer {
    AsciiBuffer id;

    public StompConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public StompEndpoint getEndpoint() {
        return (StompEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        this.id = this.getEndpoint().getNextId();
        this.getEndpoint().addConsumer(this);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.getEndpoint().removeConsumer(this);
        super.doStop();
    }

    void processExchange(Exchange exchange) {
        try {
            exchange.getIn().getHeaders().entrySet().removeIf(e -> this.getEndpoint().getHeaderFilterStrategy().applyFilterToExternalHeaders((String)e.getKey(), e.getValue(), exchange));
            this.getProcessor().process(exchange);
        }
        catch (Exception e2) {
            exchange.setException((Throwable)e2);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)exchange.getException());
        }
    }
}

