/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SshUtils.class);

    public static <S> List<NamedFactory<S>> filter(Class<S> type, Collection<NamedFactory<S>> factories, String[] names) {
        ArrayList<NamedFactory<S>> list = new ArrayList<NamedFactory<S>>();
        LOGGER.trace("List of available {} algorithms : {}", (Object)type.getSimpleName().toLowerCase(), (Object)factories.stream().map(NamedResource::getName).collect(Collectors.joining(",")));
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (NamedFactory<S> factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured {} '{}' not available", (Object)type.getSimpleName().toLowerCase(), (Object)name);
        }
        return list;
    }

    public static List<KeyExchangeFactory> filter(List<KeyExchangeFactory> factories, String[] names) {
        ArrayList<KeyExchangeFactory> list = new ArrayList<KeyExchangeFactory>();
        LOGGER.info("List of available kex algorithms : {}", (Object)factories.stream().map(NamedResource::getName).collect(Collectors.joining(",")));
        for (String name : names) {
            name = name.trim();
            boolean found = false;
            for (KeyExchangeFactory factory : factories) {
                if (!factory.getName().equals(name)) continue;
                list.add(factory);
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.warn("Configured KeyExchangeFactory '{}' not available", (Object)name);
        }
        return list;
    }

    public static void configureMacs(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank((CharSequence)names)) {
            return;
        }
        Set builtIn = BuiltinMacs.VALUES;
        NavigableSet registered = BuiltinMacs.getRegisteredExtensions();
        HashSet allMacFactories = new HashSet();
        allMacFactories.addAll(builtIn);
        allMacFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories((boolean)false, allMacFactories);
        factoryManager.setMacFactories(SshUtils.filter(Mac.class, avail, names.split(",")));
    }

    public static void configureCiphers(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank((CharSequence)names)) {
            return;
        }
        Set builtIn = BuiltinCiphers.VALUES;
        NavigableSet registered = BuiltinCiphers.getRegisteredExtensions();
        HashSet allCipherFactories = new HashSet();
        allCipherFactories.addAll(builtIn);
        allCipherFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories((boolean)false, allCipherFactories);
        factoryManager.setCipherFactories(SshUtils.filter(Cipher.class, avail, names.split(",")));
    }

    public static void configureKexAlgorithms(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank((CharSequence)names)) {
            return;
        }
        Set builtin = BuiltinDHFactories.VALUES;
        NavigableSet dhFactories = BuiltinDHFactories.getRegisteredExtensions();
        List avail = NamedFactory.setUpTransformedFactories((boolean)false, (Collection)builtin, (Function)ClientBuilder.DH2KEX);
        factoryManager.setKeyExchangeFactories(SshUtils.filter(avail, names.split(",")));
    }

    public static void configureSignatureAlgorithms(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank((CharSequence)names)) {
            return;
        }
        Set builtIn = BuiltinSignatures.VALUES;
        NavigableSet registered = BuiltinSignatures.getRegisteredExtensions();
        HashSet allSignatureFactories = new HashSet();
        allSignatureFactories.addAll(builtIn);
        allSignatureFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories((boolean)false, allSignatureFactories);
        factoryManager.setSignatureFactories(SshUtils.filter(Signature.class, avail, names.split(",")));
    }

    public static void configureCompressions(String names, AbstractFactoryManager factoryManager) {
        if (GenericUtils.isBlank((CharSequence)names)) {
            return;
        }
        Set builtIn = BuiltinCompressions.VALUES;
        NavigableSet registered = BuiltinCompressions.getRegisteredExtensions();
        HashSet allCompressionFactories = new HashSet();
        allCompressionFactories.addAll(builtIn);
        allCompressionFactories.addAll(registered);
        List avail = NamedFactory.setUpBuiltinFactories((boolean)false, allCompressionFactories);
        factoryManager.setCompressionFactories(SshUtils.filter(Compression.class, avail, names.split(",")));
    }

    public static void configureAlgorithms(SshConfiguration configuration, SshClient client) {
        SshUtils.configureCiphers(configuration.getCiphers(), (AbstractFactoryManager)client);
        SshUtils.configureKexAlgorithms(configuration.getKex(), (AbstractFactoryManager)client);
        SshUtils.configureSignatureAlgorithms(configuration.getSignatures(), (AbstractFactoryManager)client);
        SshUtils.configureMacs(configuration.getMacs(), (AbstractFactoryManager)client);
        SshUtils.configureCompressions(configuration.getCompressions(), (AbstractFactoryManager)client);
    }
}

