/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sql.DefaultSqlEndpoint;
import org.apache.camel.component.sql.DefaultSqlPrepareStatementStrategy;
import org.apache.camel.component.sql.DefaultSqlProcessingStrategy;
import org.apache.camel.component.sql.SqlConstants;
import org.apache.camel.component.sql.SqlConsumer;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.component.sql.SqlProcessingStrategy;
import org.apache.camel.component.sql.SqlProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

@UriEndpoint(firstVersion="1.4.0", scheme="sql", title="SQL", syntax="sql:query", category={Category.DATABASE}, headersClass=SqlConstants.class)
public class SqlEndpoint
extends DefaultSqlEndpoint {
    @UriPath(description="Sets the SQL query to perform. You can externalize the query by using file: or classpath: as prefix and specify the location of the file.")
    @Metadata(required=true, supportFileReference=true, largeInput=true, inputLanguage="sql")
    private String query;
    @UriParam(label="producer", defaultValue="true", description="Whether to optimize batch by turning off auto-commit which can dramatic improve performance, and instead execute as a manual commit after the entire batch operation is complete")
    private boolean batchAutoCommitDisabled = true;

    public SqlEndpoint() {
    }

    public SqlEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SqlPrepareStatementStrategy prepareStrategy = this.getPrepareStatementStrategy() != null ? this.getPrepareStatementStrategy() : new DefaultSqlPrepareStatementStrategy(this.getSeparator());
        SqlProcessingStrategy proStrategy = this.getProcessingStrategy() != null ? this.getProcessingStrategy() : new DefaultSqlProcessingStrategy(prepareStrategy);
        SqlConsumer consumer = new SqlConsumer(this, processor, this.getJdbcTemplate(), this.query, prepareStrategy, proStrategy);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setOnConsume(this.getOnConsume());
        consumer.setOnConsumeFailed(this.getOnConsumeFailed());
        consumer.setOnConsumeBatchComplete(this.getOnConsumeBatchComplete());
        consumer.setBreakBatchOnConsumeFail(this.isBreakBatchOnConsumeFail());
        consumer.setExpectedUpdateCount(this.getExpectedUpdateCount());
        consumer.setUseIterator(this.isUseIterator());
        consumer.setRouteEmptyResultSet(this.isRouteEmptyResultSet());
        consumer.setParametersCount(this.getParametersCount());
        consumer.setAlwaysPopulateStatement(this.isAlwaysPopulateStatement());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        SqlPrepareStatementStrategy prepareStrategy = this.getPrepareStatementStrategy() != null ? this.getPrepareStatementStrategy() : new DefaultSqlPrepareStatementStrategy(this.getSeparator());
        SqlProducer result = new SqlProducer(this, this.query, this.getJdbcTemplate(), prepareStrategy, this.isBatch(), this.isAlwaysPopulateStatement(), this.isUseMessageBodyForSql());
        result.setParametersCount(this.getParametersCount());
        return result;
    }

    protected String createEndpointUri() {
        return "sql:" + UnsafeUriCharactersEncoder.encode((String)this.query);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isBatchAutoCommitDisabled() {
        return this.batchAutoCommitDisabled;
    }

    public void setBatchAutoCommitDisabled(boolean batchAutoCommitDisabled) {
        this.batchAutoCommitDisabled = batchAutoCommitDisabled;
    }
}

