/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.event.EventComponent;
import org.apache.camel.component.event.EventConsumer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

@UriEndpoint(firstVersion="1.4.0", scheme="spring-event", title="Spring Event", syntax="spring-event:name", remote=false, category={Category.MESSAGING})
public class EventEndpoint
extends DefaultEndpoint
implements ApplicationContextAware {
    private LoadBalancer loadBalancer;
    private ApplicationContext applicationContext;
    @UriPath(description="Name of endpoint")
    private String name;

    public EventEndpoint(String endpointUri, EventComponent component, String name) {
        super(endpointUri, (Component)component);
        this.applicationContext = component.getApplicationContext();
        this.name = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.applicationContext, (String)"applicationContext");
        return new DefaultProducer((Endpoint)this){

            public void process(Exchange exchange) throws Exception {
                ApplicationEvent event = EventEndpoint.this.toApplicationEvent(exchange);
                EventEndpoint.this.applicationContext.publishEvent(event);
            }
        };
    }

    public EventConsumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.applicationContext, (String)"applicationContext");
        EventConsumer answer = new EventConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Exchange exchange = this.createExchange();
        exchange.getIn().setBody((Object)event);
        try {
            this.getLoadBalancer().process(exchange);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public LoadBalancer getLoadBalancer() {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer();
        }
        return this.loadBalancer;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public EventComponent getComponent() {
        return (EventComponent)super.getComponent();
    }

    public synchronized void consumerStarted(EventConsumer consumer) {
        this.getComponent().consumerStarted(this);
        this.getLoadBalancer().addProcessor(consumer.getAsyncProcessor());
    }

    public synchronized void consumerStopped(EventConsumer consumer) {
        this.getComponent().consumerStopped(this);
        this.getLoadBalancer().removeProcessor(consumer.getAsyncProcessor());
    }

    protected LoadBalancer createLoadBalancer() {
        return new TopicLoadBalancer();
    }

    protected ApplicationEvent toApplicationEvent(Exchange exchange) {
        ApplicationEvent event = (ApplicationEvent)exchange.getIn().getBody(ApplicationEvent.class);
        if (event != null) {
            return event;
        }
        return new CamelEvent(this, exchange);
    }
}

