/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.spi;

import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.processor.DelayPolicy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spring.spi.TransactionInterceptor;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionErrorHandlerBuilder
extends ErrorHandlerBuilderSupport
implements Cloneable,
InitializingBean {
    private TransactionTemplate transactionTemplate;
    private DelayPolicy delayPolicy = new DelayPolicy();

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public DelayPolicy getDelayPolicy() {
        return this.delayPolicy;
    }

    public void setDelayPolicy(DelayPolicy delayPolicy) {
        this.delayPolicy = delayPolicy;
    }

    public ErrorHandlerBuilder copy() {
        try {
            return (ErrorHandlerBuilder)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone should be supported: " + e, e);
        }
    }

    public Processor createErrorHandler(RouteContext routeContext, Processor processor) throws Exception {
        return new TransactionInterceptor(processor, this.transactionTemplate, this.delayPolicy);
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.transactionTemplate, (String)"transactionTemplate");
    }

    public TransactionErrorHandlerBuilder delay(long delay) {
        this.getDelayPolicy().delay(delay);
        return this;
    }
}

