/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class Main
extends ServiceSupport {
    private static final Log LOG = LogFactory.getLog(Main.class);
    private String applicationContextUri = "META-INF/spring/*.xml";
    private AbstractApplicationContext applicationContext;
    private List<Option> options = new ArrayList<Option>();
    private CountDownLatch latch = new CountDownLatch(1);
    private AtomicBoolean completed = new AtomicBoolean(false);
    private long duration = -1L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private String dotOutputDir;

    public Main() {
        this.addOption(new Option("h", "help", "Displays the help screen"){

            @Override
            protected void doProcess(String arg, LinkedList<String> remainingArgs) {
                Main.this.showOptions();
                Main.this.completed();
            }
        });
        this.addOption(new ParameterOption("a", "applicationContext", "Sets the classpath based pring ApplicationContext", "applicationContext"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setApplicationContextUri(parameter);
            }
        });
        this.addOption(new ParameterOption("o", "outdir", "Sets the DOT output directory where the visual representations of the routes are generated", "dot"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                Main.this.setDotOutputDir(parameter);
            }
        });
        this.addOption(new ParameterOption("d", "duration", "Sets the time duration that the applicaiton will run for, by default in milliseconds. You can use '10s' for 10 seconds etc", "duration"){

            @Override
            protected void doProcess(String arg, String parameter, LinkedList<String> remainingArgs) {
                String value = parameter.toUpperCase();
                if (value.endsWith("S")) {
                    value = value.substring(0, value.length() - 1);
                    Main.this.setTimeUnit(TimeUnit.SECONDS);
                }
                Main.this.setDuration(Integer.parseInt(value));
            }
        });
    }

    public static void main(String ... args) {
        new Main().run(args);
    }

    public void run(String[] args) {
        this.parseArguments(args);
        this.run();
    }

    public void run() {
        if (!this.completed.get()) {
            try {
                this.start();
                this.postProcessContext();
                this.waitUntilCompleted();
                this.stop();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed: " + e), (Throwable)e);
            }
        }
    }

    public void completed() {
        this.completed.set(true);
        this.latch.countDown();
    }

    public void showOptions() {
        System.out.println("Apache Camel Runner takes the following options");
        System.out.println();
        for (Option option : this.options) {
            System.out.println("  " + option.getAbbreviation() + " or " + option.getFullName() + " = " + option.getDescription());
        }
    }

    public void parseArguments(String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        boolean valid = true;
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            boolean handled = false;
            for (Option option : this.options) {
                if (!option.processOption(arg, args)) continue;
                handled = true;
                break;
            }
            if (handled) continue;
            System.out.println("Unknown option: " + arg);
            System.out.println();
            valid = false;
            break;
        }
        if (!valid) {
            this.showOptions();
            this.completed();
        }
    }

    public void addOption(Option option) {
        this.options.add(option);
    }

    public AbstractApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(AbstractApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContextUri() {
        return this.applicationContextUri;
    }

    public void setApplicationContextUri(String applicationContextUri) {
        this.applicationContextUri = applicationContextUri;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getDotOutputDir() {
        return this.dotOutputDir;
    }

    public void setDotOutputDir(String dotOutputDir) {
        this.dotOutputDir = dotOutputDir;
    }

    protected void doStart() throws Exception {
        LOG.info((Object)("Apache Camel " + this.getVersion() + " starting"));
        if (this.applicationContext == null) {
            this.applicationContext = this.createDefaultApplicationContext();
        }
        this.applicationContext.start();
    }

    protected AbstractApplicationContext createDefaultApplicationContext() {
        String[] args = this.getApplicationContextUri().split(";");
        return new ClassPathXmlApplicationContext(args);
    }

    protected void doStop() throws Exception {
        LOG.info((Object)"Apache Camel terminating");
        if (this.applicationContext != null) {
            this.applicationContext.close();
        }
    }

    protected void waitUntilCompleted() {
        while (!this.completed.get()) {
            try {
                if (this.duration > 0L) {
                    TimeUnit unit = this.getTimeUnit();
                    LOG.info((Object)("Waiting for: " + this.duration + " " + (Object)((Object)unit)));
                    this.latch.await(this.duration, unit);
                    this.completed.set(true);
                    continue;
                }
                this.latch.await();
            }
            catch (InterruptedException e) {
                LOG.debug((Object)("Caught: " + e));
            }
        }
    }

    protected void postProcessContext() throws Exception {
        if (ObjectHelper.isNotNullAndNonEmpty((String)this.dotOutputDir)) {
            RouteDotGenerator generator = new RouteDotGenerator(this.dotOutputDir);
            SpringCamelContext camelContext = SpringCamelContext.springCamelContext((ApplicationContext)this.applicationContext);
            LOG.info((Object)("Generating DOT file for routes: " + this.dotOutputDir + " for: " + (Object)((Object)camelContext)));
            generator.drawRoutes((CamelContext)camelContext);
        }
    }

    protected String getVersion() {
        Package aPackage = Package.getPackage("org.apache.camel");
        if (aPackage != null) {
            String version = aPackage.getImplementationVersion();
            if (version == null && (version = aPackage.getSpecificationVersion()) == null) {
                version = "";
            }
            return version;
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ParameterOption
    extends Option {
        private String parameterName;

        protected ParameterOption(String abbreviation, String fullName, String description, String parameterName) {
            super(abbreviation, fullName, description);
            this.parameterName = parameterName;
        }

        @Override
        protected void doProcess(String arg, LinkedList<String> remainingArgs) {
            if (remainingArgs.isEmpty()) {
                System.err.println("Expected fileName for ");
                Main.this.showOptions();
                Main.this.completed();
            } else {
                String parameter = remainingArgs.removeFirst();
                this.doProcess(arg, parameter, remainingArgs);
            }
        }

        protected abstract void doProcess(String var1, String var2, LinkedList<String> var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Option {
        private String abbreviation;
        private String fullName;
        private String description;

        protected Option(String abbreviation, String fullName, String description) {
            this.abbreviation = "-" + abbreviation;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(String arg, LinkedList<String> remainingArgs) {
            if (arg.equalsIgnoreCase(this.abbreviation) || this.fullName.startsWith(arg)) {
                this.doProcess(arg, remainingArgs);
                return true;
            }
            return false;
        }

        public String getAbbreviation() {
            return this.abbreviation;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        protected abstract void doProcess(String var1, LinkedList<String> var2);
    }
}

