/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mock.AssertionClause;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExpressionComparator;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockEndpoint
extends DefaultEndpoint<Exchange> {
    private static final transient Log LOG = LogFactory.getLog(MockEndpoint.class);
    private int expectedCount = -1;
    private int counter;
    private Map<Integer, Processor> processors = new HashMap<Integer, Processor>();
    private List<Exchange> receivedExchanges = new CopyOnWriteArrayList<Exchange>();
    private List<Throwable> failures = new CopyOnWriteArrayList<Throwable>();
    private List<Runnable> tests = new CopyOnWriteArrayList<Runnable>();
    private CountDownLatch latch;
    private long sleepForEmptyTest = 1000L;
    private long defaulResultWaitMillis = 20000L;
    private int expectedMinimumCount = -1;
    private List expectedBodyValues;
    private List actualBodyValues = new ArrayList();

    public MockEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public static void assertWait(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        long start = System.currentTimeMillis();
        long left = unit.toMillis(timeout);
        long end = start + left;
        for (MockEndpoint endpoint : endpoints) {
            if (!endpoint.await(left, TimeUnit.MILLISECONDS)) {
                throw new AssertionError((Object)("Timeout waiting for endpoints to receive enough messages. " + endpoint.getEndpointUri() + " timed out."));
            }
            left = end - System.currentTimeMillis();
            if (left > 0L) continue;
            left = 0L;
        }
    }

    public static void assertIsSatisfied(long timeout, TimeUnit unit, MockEndpoint ... endpoints) throws InterruptedException {
        MockEndpoint.assertWait(timeout, unit, endpoints);
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            endpoint.assertIsSatisfied();
        }
    }

    public static void assertIsSatisfied(CamelContext context) throws InterruptedException {
        Collection endpoints = context.getSingletonEndpoints();
        for (Endpoint endpoint : endpoints) {
            if (!(endpoint instanceof MockEndpoint)) continue;
            MockEndpoint mockEndpoint = (MockEndpoint)endpoint;
            mockEndpoint.assertIsSatisfied();
        }
    }

    public static void expectsMessageCount(int count, MockEndpoint ... endpoints) throws InterruptedException {
        for (MockEndpoint endpoint : endpoints) {
            MockEndpoint.expectsMessageCount(count, new MockEndpoint[0]);
        }
    }

    public Consumer<Exchange> createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume from this endpoint");
    }

    public Producer<Exchange> createProducer() throws Exception {
        return new DefaultProducer<Exchange>((Endpoint)this){

            public void process(Exchange exchange) {
                MockEndpoint.this.onExchange(exchange);
            }
        };
    }

    public void whenExchangeReceived(int index, Processor processor) {
        this.processors.put(index, processor);
    }

    public void assertIsSatisfied() throws InterruptedException {
        this.assertIsSatisfied(this.sleepForEmptyTest);
    }

    public void assertIsSatisfied(long timeoutForEmptyEndpoints) throws InterruptedException {
        LOG.info((Object)("Asserting: " + (Object)((Object)this) + " is satisfied"));
        if (this.expectedCount >= 0) {
            if (this.expectedCount != this.getReceivedCounter()) {
                if (this.expectedCount == 0) {
                    if (timeoutForEmptyEndpoints > 0L) {
                        LOG.debug((Object)("Sleeping for: " + timeoutForEmptyEndpoints + " millis to check there really are no messages received"));
                        Thread.sleep(timeoutForEmptyEndpoints);
                    }
                } else {
                    this.waitForCompleteLatch();
                }
            }
            this.assertEquals("Received message count", this.expectedCount, this.getReceivedCounter());
        } else if (this.expectedMinimumCount > 0 && this.getReceivedCounter() < this.expectedMinimumCount) {
            this.waitForCompleteLatch();
        }
        if (this.expectedMinimumCount >= 0) {
            int receivedCounter = this.getReceivedCounter();
            this.assertTrue("Received message count " + receivedCounter + ", expected at least " + this.expectedCount, this.expectedCount <= receivedCounter);
        }
        for (Runnable test : this.tests) {
            test.run();
        }
        for (Throwable failure : this.failures) {
            if (failure == null) continue;
            LOG.error((Object)("Caught on " + this.getEndpointUri() + " Exception: " + failure), failure);
            this.fail("Failed due to caught exception: " + failure);
        }
    }

    public void assertIsNotSatisfied() throws InterruptedException {
        try {
            this.assertIsSatisfied();
            this.fail("Expected assertion failure!");
        }
        catch (AssertionError e) {
            LOG.info((Object)("Caught expected failure: " + e));
        }
    }

    public void expectedMessageCount(int expectedCount) {
        this.expectedCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(expectedCount);
    }

    public void expectedMinimumMessageCount(int expectedCount) {
        this.expectedMinimumCount = expectedCount;
        this.latch = expectedCount <= 0 ? null : new CountDownLatch(this.expectedMinimumCount);
    }

    public void expectedBodiesReceived(List bodies) {
        this.expectedMessageCount(bodies.size());
        this.expectedBodyValues = bodies;
        this.actualBodyValues = new ArrayList();
        this.expects(new Runnable(){

            public void run() {
                for (int i = 0; i < MockEndpoint.this.expectedBodyValues.size(); ++i) {
                    Exchange exchange = MockEndpoint.this.getReceivedExchanges().get(i);
                    MockEndpoint.this.assertTrue("No exchange received for counter: " + i, exchange != null);
                    Object expectedBody = MockEndpoint.this.expectedBodyValues.get(i);
                    Object actualBody = MockEndpoint.this.actualBodyValues.get(i);
                    MockEndpoint.this.assertEquals("Body of message: " + i, expectedBody, actualBody);
                }
            }
        });
    }

    public void expectedBodiesReceived(Object ... bodies) {
        ArrayList<Object> bodyList = new ArrayList<Object>();
        for (Object body : bodies) {
            bodyList.add(body);
        }
        this.expectedBodiesReceived(bodyList);
    }

    public void expectsAscending(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertMessagesAscending((Expression<Exchange>)expression);
            }
        });
    }

    public void expectsDescending(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertMessagesDescending((Expression<Exchange>)expression);
            }
        });
    }

    public void expectsNoDuplicates(final Expression<Exchange> expression) {
        this.expects(new Runnable(){

            public void run() {
                MockEndpoint.this.assertNoDuplicates((Expression<Exchange>)expression);
            }
        });
    }

    public void assertMessagesAscending(Expression<Exchange> expression) {
        this.assertMessagesSorted(expression, true);
    }

    public void assertMessagesDescending(Expression<Exchange> expression) {
        this.assertMessagesSorted(expression, false);
    }

    protected void assertMessagesSorted(Expression<Exchange> expression, boolean ascending) {
        String type = ascending ? "ascending" : "descending";
        ExpressionComparator comparator = new ExpressionComparator(expression);
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 1; i < list.size(); ++i) {
            Exchange e2;
            int j = i - 1;
            Exchange e1 = list.get(j);
            int result = comparator.compare(e1, e2 = list.get(i));
            if (result == 0) {
                this.fail("Messages not " + type + ". Messages" + j + " and " + i + " are equal with value: " + expression.evaluate(e1) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            if (!ascending) {
                result *= -1;
            }
            if (result <= 0) continue;
            this.fail("Messages not " + type + ". Message " + j + " has value: " + expression.evaluate(e1) + " and message " + i + " has value: " + expression.evaluate(e2) + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
        }
    }

    public void assertNoDuplicates(Expression<Exchange> expression) {
        HashMap<Object, Exchange> map = new HashMap<Object, Exchange>();
        List<Exchange> list = this.getReceivedExchanges();
        for (int i = 0; i < list.size(); ++i) {
            Exchange e2 = list.get(i);
            Object key = expression.evaluate(e2);
            Exchange e1 = (Exchange)map.get(key);
            if (e1 != null) {
                this.fail("Duplicate message found on message " + i + " has value: " + key + " for expression: " + expression + ". Exchanges: " + e1 + " and " + e2);
                continue;
            }
            map.put(key, e2);
        }
    }

    public void expects(Runnable runnable) {
        this.tests.add(runnable);
    }

    public AssertionClause message(final int messageIndex) {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                this.applyAssertionOn(MockEndpoint.this, messageIndex, MockEndpoint.this.assertExchangeReceived(messageIndex));
            }
        };
        this.expects(clause);
        return clause;
    }

    public AssertionClause allMessages() {
        AssertionClause clause = new AssertionClause(){

            public void run() {
                List<Exchange> list = MockEndpoint.this.getReceivedExchanges();
                int index = 0;
                for (Exchange exchange : list) {
                    this.applyAssertionOn(MockEndpoint.this, index++, exchange);
                }
            }
        };
        this.expects(clause);
        return clause;
    }

    public Exchange assertExchangeReceived(int index) {
        int count = this.getReceivedCounter();
        this.assertTrue("Not enough messages received. Was: " + count, count > index);
        return this.getReceivedExchanges().get(index);
    }

    public List<Throwable> getFailures() {
        return this.failures;
    }

    public int getReceivedCounter() {
        return this.getReceivedExchanges().size();
    }

    public List<Exchange> getReceivedExchanges() {
        return this.receivedExchanges;
    }

    public int getExpectedCount() {
        return this.expectedCount;
    }

    public long getSleepForEmptyTest() {
        return this.sleepForEmptyTest;
    }

    public void setSleepForEmptyTest(long sleepForEmptyTest) {
        this.sleepForEmptyTest = sleepForEmptyTest;
    }

    public long getDefaulResultWaitMillis() {
        return this.defaulResultWaitMillis;
    }

    public void setDefaulResultWaitMillis(long defaulResultWaitMillis) {
        this.defaulResultWaitMillis = defaulResultWaitMillis;
    }

    protected synchronized void onExchange(Exchange exchange) {
        try {
            Message in = exchange.getIn();
            Object actualBody = in.getBody();
            if (this.expectedBodyValues != null) {
                int index = this.actualBodyValues.size();
                if (this.expectedBodyValues.size() > index) {
                    Object expectedBody = this.expectedBodyValues.get(index);
                    if (expectedBody != null) {
                        actualBody = in.getBody(expectedBody.getClass());
                    }
                    this.actualBodyValues.add(actualBody);
                }
            }
            LOG.debug((Object)(this.getEndpointUri() + " >>>> " + ++this.counter + " : " + exchange + " with body: " + actualBody));
            this.receivedExchanges.add(exchange);
            Processor processor = this.processors.get(this.getReceivedCounter());
            if (processor != null) {
                processor.process(exchange);
            }
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
        catch (Exception e) {
            this.failures.add(e);
        }
    }

    protected void waitForCompleteLatch() throws InterruptedException {
        if (this.latch == null) {
            this.fail("Should have a latch!");
        }
        LOG.debug((Object)("Waiting on the latch for: " + this.defaulResultWaitMillis + " millis"));
        this.latch.await(this.defaulResultWaitMillis, TimeUnit.MILLISECONDS);
    }

    protected void assertEquals(String message, Object expectedValue, Object actualValue) {
        if (!ObjectHelper.equals((Object)expectedValue, (Object)actualValue)) {
            this.fail(message + ". Expected: <" + expectedValue + "> but was: <" + actualValue + ">");
        }
    }

    protected void assertTrue(String message, boolean predicate) {
        if (!predicate) {
            this.fail(message);
        }
    }

    protected void fail(Object message) {
        if (LOG.isDebugEnabled()) {
            List<Exchange> list = this.getReceivedExchanges();
            int index = 0;
            for (Exchange exchange : list) {
                LOG.debug((Object)("Received[" + ++index + "]: " + exchange));
            }
        }
        throw new AssertionError((Object)(this.getEndpointUri() + " " + message));
    }

    public int getExpectedMinimumCount() {
        return this.expectedMinimumCount;
    }

    public void await() throws InterruptedException {
        if (this.latch != null) {
            this.latch.await();
        }
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.latch != null) {
            return this.latch.await(timeout, unit);
        }
        return true;
    }

    public boolean isSingleton() {
        return true;
    }
}

