/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.camel.Exchange;

public class BeanInvocation {
    private final Object proxy;
    private final Method method;
    private final Object[] args;

    public BeanInvocation(Object proxy, Method method, Object[] args) {
        this.proxy = proxy;
        this.method = method;
        this.args = args;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void invoke(Object pojo, Exchange exchange) {
        try {
            Object response = this.getMethod().invoke(pojo, this.getArgs());
            exchange.getOut().setBody(response);
        }
        catch (InvocationTargetException e) {
            exchange.setException(e.getCause());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

