/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.component.redis.RedisComponent;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisConstants;
import org.apache.camel.component.redis.RedisConsumer;
import org.apache.camel.component.redis.RedisProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.springframework.data.redis.core.RedisTemplate;

@UriEndpoint(firstVersion="2.11.0", scheme="spring-redis", title="Spring Redis", syntax="spring-redist:host:port", category={Category.CACHE}, headersClass=RedisConstants.class)
public class RedisEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private final RedisConfiguration configuration;

    public RedisEndpoint(String uri, RedisComponent component, RedisConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        Command defaultCommand = this.configuration.getCommand();
        if (defaultCommand == null) {
            defaultCommand = Command.SET;
        }
        RedisTemplate<?, ?> redisTemplate = this.configuration.getRedisTemplate();
        return new RedisProducer((Endpoint)this, "CamelRedis.Command", defaultCommand.name(), new RedisClient(redisTemplate));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RedisConsumer answer = new RedisConsumer(this, processor, this.configuration);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    public String getServiceProtocol() {
        return "redis";
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.configuration.stop();
    }

    public RedisConfiguration getConfiguration() {
        return this.configuration;
    }
}

