/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.cloud.config;

import org.apache.camel.CamelContext;
import org.apache.camel.component.spring.cloud.config.SpringCloudConfigPropertiesFunction;
import org.apache.camel.vault.SpringCloudConfigConfiguration;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.logging.DeferredLogs;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigClientRequestTemplateFactory;
import org.springframework.cloud.config.client.ConfigServerConfigDataLoader;
import org.springframework.cloud.config.client.ConfigServerConfigDataResource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.web.client.RestTemplate;

public class SpringConfigProvider {
    public ConfigData getConfigData(CamelContext camelContext) {
        SpringCloudConfigConfiguration configuration = camelContext.getVaultConfiguration().springConfig();
        ConfigServerConfigDataLoader configServerConfigDataLoader = new ConfigServerConfigDataLoader((DeferredLogFactory)new DeferredLogs());
        StandardEnvironment camelEnvironment = new StandardEnvironment();
        ConfigClientProperties configClientProperties = new ConfigClientProperties((Environment)camelEnvironment);
        configClientProperties.setName(camelContext.getName());
        configClientProperties.setUsername(configuration.getUsername());
        configClientProperties.setPassword(configuration.getPassword());
        configClientProperties.setToken(configuration.getToken());
        if (configuration.getLabel() != null) {
            configClientProperties.setLabel(configuration.getLabel());
        }
        if (configuration.getProfile() != null) {
            configClientProperties.setProfile(configuration.getProfile());
        }
        if (configuration.getUris() != null && !configuration.getUris().isEmpty()) {
            configClientProperties.setUri(configuration.getUris().split(","));
        }
        DefaultBootstrapContext configurableBootstrapContext = new DefaultBootstrapContext();
        configurableBootstrapContext.register(RestTemplate.class, BootstrapRegistry.InstanceSupplier.of((Object)new RestTemplate()));
        configurableBootstrapContext.register(ConfigClientProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)configClientProperties));
        configurableBootstrapContext.register(ConfigClientRequestTemplateFactory.class, BootstrapRegistry.InstanceSupplier.of((Object)new ConfigClientRequestTemplateFactory(LogFactory.getLog(SpringCloudConfigPropertiesFunction.class), configClientProperties)));
        ConfigDataLoaderContext configDataLoaderContext = () -> SpringConfigProvider.lambda$getConfigData$0((ConfigurableBootstrapContext)configurableBootstrapContext);
        ConfigServerConfigDataResource configServerConfigDataResource = new ConfigServerConfigDataResource(configClientProperties, true, null);
        ConfigData configData = configServerConfigDataLoader.doLoad(configDataLoaderContext, configServerConfigDataResource);
        return configData;
    }

    private static /* synthetic */ ConfigurableBootstrapContext lambda$getConfigData$0(ConfigurableBootstrapContext configurableBootstrapContext) {
        return configurableBootstrapContext;
    }
}

