/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.cloud.config;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.spring.cloud.config.SpringConfigProvider;
import org.apache.camel.component.spring.cloud.config.SpringConfigRemaindersCache;
import org.apache.camel.spi.annotations.PropertiesFunction;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

@PropertiesFunction(value="spring-config")
public class SpringCloudConfigPropertiesFunction
extends ServiceSupport
implements org.apache.camel.spi.PropertiesFunction,
CamelContextAware,
EnvironmentAware {
    private CamelContext camelContext;
    private Environment environment;

    public String apply(String remainder) {
        if (this.environment != null) {
            return this.environment.getProperty(remainder);
        }
        ConfigData configData = new SpringConfigProvider().getConfigData(this.getCamelContext());
        if (configData == null) {
            throw new RuntimeCamelException("Cannot retrieve any config data from Spring Config for property " + remainder);
        }
        String result = null;
        for (PropertySource propertySource : configData.getPropertySources()) {
            if (!propertySource.containsProperty(remainder)) continue;
            result = propertySource.getProperty(remainder).toString();
        }
        SpringConfigRemaindersCache.put(remainder, result);
        return result;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getName() {
        return "spring-config";
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

