/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.endpoint;

import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointMvcAdapter;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

abstract class AbstractCamelMvcEndpoint<T extends Endpoint>
extends EndpointMvcAdapter {
    private final T delegate;

    protected AbstractCamelMvcEndpoint(String path, T delegate) {
        super(delegate);
        this.delegate = delegate;
        this.setPath(path);
    }

    protected T delegate() {
        return this.delegate;
    }

    protected Object doIfEnabled(Supplier<Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return supplier.get();
    }

    protected Object doIfEnabled(Function<T, Object> supplier) {
        if (!this.delegate.isEnabled()) {
            return this.getDisabledResponse();
        }
        return supplier.apply(this.delegate);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public static class GenericException
    extends RuntimeException {
        public GenericException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

