/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.io.FileNotFoundException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.RestsDefinition;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelMainRunController;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.apache.camel.spring.boot.FatJarRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;

public class RoutesCollector
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RoutesCollector.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;
    private final CamelConfigurationProperties configurationProperties;

    public RoutesCollector(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations, CamelConfigurationProperties configurationProperties) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = new ArrayList<CamelContextConfiguration>(camelContextConfigurations);
        this.configurationProperties = configurationProperties;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        if (this.applicationContext.equals(applicationContext)) {
            CamelContext camelContext = (CamelContext)event.getApplicationContext().getBean(CamelContext.class);
            if (camelContext.getStatus().isStopped()) {
                LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
                for (RoutesBuilder routesBuilder : applicationContext.getBeansOfType(RoutesBuilder.class).values()) {
                    boolean abs = Modifier.isAbstract(routesBuilder.getClass().getModifiers());
                    boolean farJarRouter = FatJarRouter.class.equals(routesBuilder.getClass());
                    if (abs || farJarRouter) continue;
                    try {
                        LOG.debug("Injecting following route into the CamelContext: {}", (Object)routesBuilder);
                        camelContext.addRoutes(routesBuilder);
                    }
                    catch (Exception e) {
                        throw new CamelSpringBootInitializationException(e);
                    }
                }
                try {
                    boolean scanRests;
                    boolean scan;
                    boolean bl = scan = !this.configurationProperties.getXmlRoutes().equals("false");
                    if (scan) {
                        this.loadXmlRoutes(applicationContext, camelContext, this.configurationProperties.getXmlRoutes());
                    }
                    boolean bl2 = scanRests = !this.configurationProperties.getXmlRests().equals("false");
                    if (scanRests) {
                        this.loadXmlRests(applicationContext, camelContext, this.configurationProperties.getXmlRests());
                    }
                    for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                        LOG.debug("CamelContextConfiguration found. Invoking beforeApplicationStart: {}", (Object)camelContextConfiguration);
                        camelContextConfiguration.beforeApplicationStart(camelContext);
                    }
                    if (this.configurationProperties.isMainRunController()) {
                        LOG.info("Starting CamelMainRunController to ensure the main thread keeps running");
                        CamelMainRunController controller = new CamelMainRunController(applicationContext, camelContext);
                        controller.start();
                    } else {
                        this.maybeStart(camelContext);
                    }
                    for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                        LOG.debug("CamelContextConfiguration found. Invoking afterApplicationStart: {}", (Object)camelContextConfiguration);
                        camelContextConfiguration.afterApplicationStart(camelContext);
                    }
                }
                catch (Exception e) {
                    throw new CamelSpringBootInitializationException(e);
                }
            } else {
                LOG.debug("Camel already started, not adding routes.");
            }
        } else {
            LOG.debug("Ignore ContextRefreshedEvent: {}", (Object)event);
        }
    }

    private void maybeStart(CamelContext camelContext) throws Exception {
        boolean skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"));
        if (skip) {
            LOG.info("Skipping starting CamelContext as system property skipStartingCamelContext is set to be true.");
        } else {
            camelContext.start();
        }
    }

    private void loadXmlRoutes(ApplicationContext applicationContext, CamelContext camelContext, String directory) throws Exception {
        LOG.info("Loading additional Camel XML routes from: {}", (Object)directory);
        try {
            Resource[] xmlRoutes;
            for (Resource xmlRoute : xmlRoutes = applicationContext.getResources(directory)) {
                LOG.debug("Found XML route: {}", (Object)xmlRoute);
                RoutesDefinition xmlDefinition = camelContext.loadRoutesDefinition(xmlRoute.getInputStream());
                camelContext.addRouteDefinitions((Collection)xmlDefinition.getRoutes());
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("No XML routes found in {}. Skipping XML routes detection.", (Object)directory);
        }
    }

    private void loadXmlRests(ApplicationContext applicationContext, CamelContext camelContext, String directory) {
        LOG.info("Loading additional Camel XML rests from: {}", (Object)directory);
        try {
            Resource[] xmlRests;
            for (Resource xmlRest : xmlRests = applicationContext.getResources(directory)) {
                RestsDefinition xmlDefinitions = camelContext.loadRestsDefinition(xmlRest.getInputStream());
                camelContext.addRestDefinitions((Collection)xmlDefinitions.getRests());
                for (RestDefinition xmlDefinition : xmlDefinitions.getRests()) {
                    List routeDefinitions = xmlDefinition.asRouteDefinition(camelContext);
                    camelContext.addRouteDefinitions((Collection)routeDefinitions);
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug("No XML rests found in {}. Skipping XML rests detection.", (Object)directory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

