/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SplunkEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "splunk".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "name", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(47);
        props.add("app");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("connectionTimeout");
        props.add("count");
        props.add("delay");
        props.add("earliestTime");
        props.add("eventHost");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("greedy");
        props.add("host");
        props.add("index");
        props.add("initEarliestTime");
        props.add("initialDelay");
        props.add("latestTime");
        props.add("lazyStartProducer");
        props.add("name");
        props.add("owner");
        props.add("password");
        props.add("pollStrategy");
        props.add("port");
        props.add("raw");
        props.add("repeatCount");
        props.add("runLoggingLevel");
        props.add("savedSearch");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("scheme");
        props.add("search");
        props.add("sendEmptyMessageWhenIdle");
        props.add("source");
        props.add("sourceType");
        props.add("sslProtocol");
        props.add("startScheduler");
        props.add("streaming");
        props.add("tcpReceiverLocalPort");
        props.add("tcpReceiverPort");
        props.add("timeUnit");
        props.add("token");
        props.add("useFixedDelay");
        props.add("useSunHttpsHandler");
        props.add("username");
        props.add("validateCertificates");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("password");
        secretProps.add("token");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

