/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.servlet.AttachmentHttpBinding;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpCommonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.0.0", scheme="servlet", extendsScheme="http", title="Servlet", syntax="servlet:contextPath", consumerOnly=true, label="http")
@Metadata(excludeProperties="httpUri")
public class ServletEndpoint
extends HttpCommonEndpoint {
    private HttpBinding binding;
    @UriPath(label="consumer")
    @Metadata(required=true)
    private String contextPath;
    @UriParam(label="consumer", defaultValue="CamelServlet")
    private String servletName;
    @UriParam(label="consumer,advanced")
    private boolean attachmentMultipartBinding;
    @UriParam(label="consumer,advanced")
    private String fileNameExtWhitelist;

    public ServletEndpoint() {
    }

    public ServletEndpoint(String endPointURI, ServletComponent component, URI httpUri) throws URISyntaxException {
        super(endPointURI, (HttpCommonComponent)component, httpUri);
        this.contextPath = httpUri.getPath();
    }

    public ServletComponent getComponent() {
        return (ServletComponent)super.getComponent();
    }

    public HttpBinding getHttpBinding() {
        if (this.binding == null) {
            this.binding = this.isAttachmentMultipartBinding() ? new AttachmentHttpBinding() : new DefaultHttpBinding();
            this.binding.setFileNameExtWhitelist(this.getFileNameExtWhitelist());
            this.binding.setTransferException(this.isTransferException());
            this.binding.setMuteException(this.isMuteException());
            if (this.getComponent() != null) {
                this.binding.setAllowJavaSerializedObject(this.getComponent().isAllowJavaSerializedObject());
            }
            this.binding.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
            this.binding.setEagerCheckContentAvailable(this.isEagerCheckContentAvailable());
            this.binding.setMapHttpMessageBody(this.isMapHttpMessageBody());
            this.binding.setMapHttpMessageHeaders(this.isMapHttpMessageHeaders());
            this.binding.setMapHttpMessageFormUrlEncodedBody(this.isMapHttpMessageFormUrlEncodedBody());
        }
        return this.binding;
    }

    public void setHttpBinding(HttpBinding binding) {
        super.setHttpBinding(binding);
        this.binding = binding;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setServletName(String name) {
        this.servletName = name;
    }

    public String getServletName() {
        return this.servletName;
    }

    public boolean isAttachmentMultipartBinding() {
        return this.attachmentMultipartBinding;
    }

    public void setAttachmentMultipartBinding(boolean attachmentMultipartBinding) {
        this.attachmentMultipartBinding = attachmentMultipartBinding;
    }

    public String getFileNameExtWhitelist() {
        return this.fileNameExtWhitelist;
    }

    public void setFileNameExtWhitelist(String fileNameExtWhitelist) {
        this.fileNameExtWhitelist = fileNameExtWhitelist;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("You cannot create producer with servlet endpoint, please consider to use http endpoint.");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ServletConsumer answer = new ServletConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isLenientProperties() {
        return false;
    }
}

