/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.servlet.DefaultHttpRegistry;
import org.apache.camel.component.servlet.HttpRegistry;
import org.apache.camel.component.servlet.ServletConsumer;
import org.apache.camel.component.servlet.ServletEndpoint;
import org.apache.camel.component.servlet.ServletRestHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpCommonComponent;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.RestApiConsumerFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestConsumerFactory;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class ServletComponent
extends HttpCommonComponent
implements RestConsumerFactory,
RestApiConsumerFactory {
    private String servletName = "CamelServlet";
    private HttpRegistry httpRegistry;

    public ServletComponent() {
        super(ServletEndpoint.class);
    }

    public ServletComponent(Class<? extends ServletEndpoint> endpointClass) {
        super(endpointClass);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Boolean throwExceptionOnFailure = (Boolean)this.getAndRemoveParameter(parameters, "throwExceptionOnFailure", Boolean.class);
        Boolean transferException = (Boolean)this.getAndRemoveParameter(parameters, "transferException", Boolean.class);
        Boolean bridgeEndpoint = (Boolean)this.getAndRemoveParameter(parameters, "bridgeEndpoint", Boolean.class);
        HttpBinding binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        if (binding == null) {
            binding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        }
        Boolean matchOnUriPrefix = (Boolean)this.getAndRemoveParameter(parameters, "matchOnUriPrefix", Boolean.class);
        String servletName = (String)this.getAndRemoveParameter(parameters, "servletName", String.class, this.getServletName());
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        if (this.lenientContextPath()) {
            String scheme = ObjectHelper.before((String)uri, (String)":");
            String after = ObjectHelper.after((String)uri, (String)":");
            while (after.startsWith("/")) {
                after = after.substring(1);
            }
            after = "/" + after;
            uri = scheme + ":" + after;
        }
        URI httpUri = URISupport.createRemainingURI((URI)new URI(UnsafeUriCharactersEncoder.encodeHttpURI((String)uri)), parameters);
        ServletEndpoint endpoint = this.createServletEndpoint(uri, this, httpUri);
        endpoint.setServletName(servletName);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        if (binding == null) {
            binding = this.getHttpBinding();
        }
        if (binding != null) {
            endpoint.setBinding(binding);
        }
        if (throwExceptionOnFailure != null) {
            endpoint.setThrowExceptionOnFailure(throwExceptionOnFailure);
        }
        if (transferException != null) {
            endpoint.setTransferException(transferException);
        }
        if (bridgeEndpoint != null) {
            endpoint.setBridgeEndpoint(bridgeEndpoint);
        }
        if (matchOnUriPrefix != null) {
            endpoint.setMatchOnUriPrefix(matchOnUriPrefix);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected boolean lenientContextPath() {
        return true;
    }

    protected ServletEndpoint createServletEndpoint(String endpointUri, ServletComponent component, URI httpUri) throws Exception {
        return new ServletEndpoint(endpointUri, component, httpUri);
    }

    public void connect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.register(consumer);
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
        ServletConsumer sc = (ServletConsumer)consumer;
        String name = sc.getEndpoint().getServletName();
        HttpRegistry registry = this.httpRegistry;
        if (registry == null) {
            registry = DefaultHttpRegistry.getHttpRegistry(name);
        }
        registry.unregister(consumer);
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public HttpRegistry getHttpRegistry() {
        return this.httpRegistry;
    }

    public void setHttpRegistry(HttpRegistry httpRegistry) {
        this.httpRegistry = httpRegistry;
    }

    public Consumer createConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, verb, basePath, uriTemplate, consumes, produces, configuration, parameters, false);
    }

    public Consumer createApiConsumer(CamelContext camelContext, Processor processor, String contextPath, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        return this.doCreateConsumer(camelContext, processor, "GET", contextPath, null, null, null, configuration, parameters, true);
    }

    Consumer doCreateConsumer(CamelContext camelContext, Processor processor, String verb, String basePath, String uriTemplate, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters, boolean api) throws Exception {
        String path = basePath;
        if (uriTemplate != null) {
            path = uriTemplate.startsWith("/") ? path + uriTemplate : path + "/" + uriTemplate;
        }
        path = FileUtil.stripLeadingSeparator((String)path);
        RestConfiguration config = configuration;
        if (config == null) {
            config = this.getCamelContext().getRestConfiguration("servlet", true);
        }
        HashMap map = new HashMap();
        if (config.getEndpointProperties() != null && !config.getEndpointProperties().isEmpty()) {
            map.putAll(config.getEndpointProperties());
        }
        String query = URISupport.createQueryString(map);
        String url = api ? "servlet:///%s?matchOnUriPrefix=true&httpMethodRestrict=%s" : "servlet:///%s?httpMethodRestrict=%s";
        String restrict = verb.toUpperCase(Locale.US);
        url = String.format(url, path, restrict);
        if (!query.isEmpty()) {
            url = url + "&" + query;
        }
        ServletEndpoint endpoint = (ServletEndpoint)camelContext.getEndpoint(url, ServletEndpoint.class);
        this.setProperties((Object)endpoint, parameters);
        ServletRestHttpBinding binding = new ServletRestHttpBinding();
        binding.setHeaderFilterStrategy(endpoint.getHeaderFilterStrategy());
        binding.setTransferException(endpoint.isTransferException());
        binding.setEagerCheckContentAvailable(endpoint.isEagerCheckContentAvailable());
        endpoint.setBinding((HttpBinding)binding);
        Consumer consumer = endpoint.createConsumer(processor);
        if (config.getConsumerProperties() != null && !config.getConsumerProperties().isEmpty()) {
            this.setProperties(consumer, config.getConsumerProperties());
        }
        return consumer;
    }
}

