/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.parser;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.ParserResult;
import org.apache.camel.parser.helper.CamelJavaParserHelper;
import org.apache.camel.parser.helper.CamelJavaTreeParserHelper;
import org.apache.camel.parser.model.CamelCSimpleExpressionDetails;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.apache.camel.parser.model.CamelNodeDetails;
import org.apache.camel.parser.model.CamelRouteDetails;
import org.apache.camel.parser.model.CamelSimpleExpressionDetails;
import org.apache.camel.tooling.util.Strings;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public final class RouteBuilderParser {
    private RouteBuilderParser() {
    }

    public static List<CamelNodeDetails> parseRouteBuilderTree(JavaClassSource clazz, String fullyQualifiedFileName, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> methods = RouteBuilderParser.findAllConfigureMethods(clazz, includeInlinedRouteBuilders);
        CamelJavaTreeParserHelper parser = new CamelJavaTreeParserHelper();
        ArrayList<CamelNodeDetails> list = new ArrayList<CamelNodeDetails>();
        for (MethodSource<JavaClassSource> configureMethod : methods) {
            List<CamelNodeDetails> details = parser.parseCamelRouteTree(clazz, fullyQualifiedFileName, configureMethod);
            list.addAll(details);
        }
        Collections.reverse(list);
        return list;
    }

    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints) {
        RouteBuilderParser.parseRouteBuilderEndpoints(clazz, baseDir, fullyQualifiedFileName, endpoints, null, false);
    }

    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints, List<String> unparsable, boolean includeInlinedRouteBuilders) {
        for (FieldSource field : clazz.getFields()) {
            Object internal;
            String uri = null;
            Expression exp = null;
            for (Annotation ann : field.getAnnotations()) {
                boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                if (!valid) continue;
                exp = (Expression)ann.getInternal();
                if (exp instanceof SingleMemberAnnotation) {
                    exp = ((SingleMemberAnnotation)exp).getValue();
                } else if (exp instanceof NormalAnnotation) {
                    List values = ((NormalAnnotation)exp).values();
                    for (Object value : values) {
                        MemberValuePair pair = (MemberValuePair)value;
                        if (!"uri".equals(pair.getName().toString())) continue;
                        exp = pair.getValue();
                        break;
                    }
                }
                uri = CamelJavaParserHelper.getLiteralValue(clazz, null, exp);
            }
            if (Strings.isNullOrEmpty(uri) || RouteBuilderParser.findEndpointByUri(endpoints, uri) != null) continue;
            String fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
            String id = field.getName();
            CamelEndpointDetails detail = new CamelEndpointDetails();
            detail.setFileName(fileName);
            detail.setClassName(clazz.getQualifiedName());
            detail.setEndpointInstance(id);
            detail.setEndpointUri(uri);
            detail.setEndpointComponentName(RouteBuilderParser.endpointComponentName(uri));
            Object object = internal = exp != null ? exp : field.getInternal();
            if (internal instanceof ASTNode) {
                int endLine;
                int pos = ((ASTNode)internal).getStartPosition();
                int len = ((ASTNode)internal).getLength();
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), pos);
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), pos + len)) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(pos);
                int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), pos);
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
            }
            endpoints.add(detail);
        }
        List<MethodSource<JavaClassSource>> methods = RouteBuilderParser.findAllConfigureMethods(clazz, includeInlinedRouteBuilders);
        for (MethodSource<JavaClassSource> configureMethod : methods) {
            CamelEndpointDetails detail;
            String fileName;
            List<ParserResult> uris = CamelJavaParserHelper.parseCamelConsumerUris(configureMethod, true, true);
            for (ParserResult result : uris) {
                if (!result.isParsed()) {
                    if (unparsable == null) continue;
                    unparsable.add(result.getElement());
                    continue;
                }
                fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
                detail = RouteBuilderParser.buildCamelEndpointDetails(clazz, configureMethod, result, fileName);
                detail.setConsumerOnly(true);
                detail.setProducerOnly(false);
                endpoints.add(detail);
            }
            uris = CamelJavaParserHelper.parseCamelProducerUris(configureMethod, true, true);
            for (ParserResult result : uris) {
                if (!result.isParsed()) {
                    if (unparsable == null) continue;
                    unparsable.add(result.getElement());
                    continue;
                }
                fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
                detail = RouteBuilderParser.buildCamelEndpointDetails(clazz, configureMethod, result, fileName);
                detail.setConsumerOnly(false);
                detail.setProducerOnly(true);
                endpoints.add(detail);
            }
        }
    }

    private static List<MethodSource<JavaClassSource>> findAllConfigureMethods(JavaClassSource clazz, boolean includeInlinedRouteBuilders) {
        List<MethodSource<JavaClassSource>> inlinedMethods;
        ArrayList<MethodSource<JavaClassSource>> methods = new ArrayList<MethodSource<JavaClassSource>>();
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            methods.add(method);
        }
        if (includeInlinedRouteBuilders && !(inlinedMethods = CamelJavaParserHelper.findInlinedConfigureMethods(clazz)).isEmpty()) {
            methods.addAll(inlinedMethods);
        }
        return methods;
    }

    private static CamelEndpointDetails buildCamelEndpointDetails(JavaClassSource clazz, MethodSource<JavaClassSource> configureMethod, ParserResult result, String fileName) {
        int lineEnd;
        CamelEndpointDetails detail = new CamelEndpointDetails();
        detail.setFileName(fileName);
        detail.setClassName(clazz.getQualifiedName());
        detail.setMethodName(configureMethod.getName());
        detail.setEndpointInstance(null);
        detail.setEndpointUri(result.getElement());
        int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
        if (line > -1) {
            detail.setLineNumber("" + line);
        }
        if ((lineEnd = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
            detail.setLineNumberEnd("" + lineEnd);
        }
        detail.setAbsolutePosition(result.getPosition());
        int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
        if (linePos > -1) {
            detail.setLinePosition(linePos);
        }
        detail.setEndpointComponentName(RouteBuilderParser.endpointComponentName(result.getElement()));
        return detail;
    }

    private static String parseFileName(String baseDir, String fullyQualifiedFileName) {
        String fileName = fullyQualifiedFileName;
        if (fileName.startsWith(baseDir)) {
            fileName = fileName.substring(baseDir.length() + 1);
        }
        return fileName;
    }

    public static void parseRouteBuilderSimpleExpressions(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelSimpleExpressionDetails> simpleExpressions) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelLanguageExpressions(method, "simple");
            for (ParserResult result : expressions) {
                int endLine;
                if (!result.isParsed()) continue;
                String fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
                CamelSimpleExpressionDetails detail = new CamelSimpleExpressionDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(result.getPosition());
                int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
                detail.setSimple(result.getElement());
                boolean predicate = result.getPredicate() != null ? result.getPredicate() : false;
                boolean expression = !predicate;
                detail.setPredicate(predicate);
                detail.setExpression(expression);
                simpleExpressions.add(detail);
            }
        }
    }

    public static void parseRouteBuilderCSimpleExpressions(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelCSimpleExpressionDetails> csimpleExpressions) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelLanguageExpressions(method, "csimple");
            for (ParserResult result : expressions) {
                int endLine;
                if (!result.isParsed()) continue;
                String fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
                CamelCSimpleExpressionDetails detail = new CamelCSimpleExpressionDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setAbsolutePosition(result.getPosition());
                int linePos = RouteBuilderParser.findLinePosition(clazz.toUnformattedString(), result.getPosition());
                if (linePos > -1) {
                    detail.setLinePosition(linePos);
                }
                detail.setCsimple(result.getElement());
                boolean predicate = result.getPredicate() != null ? result.getPredicate() : false;
                boolean expression = !predicate;
                detail.setPredicate(predicate);
                detail.setExpression(expression);
                csimpleExpressions.add(detail);
            }
        }
    }

    public static void parseRouteBuilderRouteIds(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelRouteDetails> routes) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelRouteIds(method);
            for (ParserResult result : expressions) {
                int endLine;
                if (!result.isParsed()) continue;
                String fileName = RouteBuilderParser.parseFileName(baseDir, fullyQualifiedFileName);
                CamelRouteDetails detail = new CamelRouteDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                if ((endLine = RouteBuilderParser.findLineNumber(clazz.toUnformattedString(), result.getPosition() + result.getLength())) > -1) {
                    detail.setLineNumberEnd("" + endLine);
                }
                detail.setRouteId(result.getElement());
                routes.add(detail);
            }
        }
    }

    private static CamelEndpointDetails findEndpointByUri(List<CamelEndpointDetails> endpoints, String uri) {
        for (CamelEndpointDetails detail : endpoints) {
            if (!uri.equals(detail.getEndpointUri())) continue;
            return detail;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLineNumber(String content, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new StringReader(content));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLinePosition(String content, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new StringReader(content));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int prev = current - (line.length() + 1);
                int rel = position - prev;
                int n = rel + 1;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(58)) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }
}

