/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http;

import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.component.platform.http.spi.PlatformHttpPlugin;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="platform-http/plugin-registry")
public class PlatformHttpPluginRegistry
extends ServiceSupport
implements org.apache.camel.component.platform.http.spi.PlatformHttpPluginRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(PlatformHttpPluginRegistry.class);
    private static final String PLATFORM_HTTP_PLUGIN_FACTORY_PATH = "META-INF/services/org/apache/camel/platform-http/";
    private CamelContext camelContext;
    private final Set<PlatformHttpPlugin> plugins = new TreeSet<PlatformHttpPlugin>(Comparator.comparing(PlatformHttpPlugin::getId));

    @Override
    public <T extends PlatformHttpPlugin> Optional<T> resolvePluginById(String id, Class<T> type) {
        PlatformHttpPlugin answer = this.plugins.stream().filter(plugin -> plugin.getId().equals(id)).findFirst().orElse((PlatformHttpPlugin)this.getCamelContext().getRegistry().findByTypeWithName(PlatformHttpPlugin.class).get(id));
        if (answer == null) {
            answer = this.resolvePluginWithFactoryFinderById(id);
        }
        if (answer != null) {
            this.register(answer);
        }
        return Optional.ofNullable((PlatformHttpPlugin)type.cast(answer));
    }

    @Override
    public boolean register(PlatformHttpPlugin plugin) {
        if (this.getPlugin(plugin.getId()).isPresent()) {
            return false;
        }
        boolean result = this.plugins.add(plugin);
        if (result) {
            CamelContextAware.trySetCamelContext((Object)plugin, (CamelContext)this.camelContext);
            ServiceHelper.startService((Service)plugin);
            LOG.debug("platform-http-plugin with id {} successfully registered", (Object)plugin.getId());
        }
        return result;
    }

    private Optional<PlatformHttpPlugin> getPlugin(String id) {
        return this.plugins.stream().filter(r -> ObjectHelper.equal((Object)r.getId(), (Object)id)).findFirst();
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    private PlatformHttpPlugin resolvePluginWithFactoryFinderById(String id) {
        PlatformHttpPlugin answer = null;
        FactoryFinder factoryFinder = this.getCamelContext().getCamelContextExtension().getBootstrapFactoryFinder(PLATFORM_HTTP_PLUGIN_FACTORY_PATH);
        Class type = factoryFinder.findOptionalClass(id).orElse(null);
        if (type != null) {
            if (PlatformHttpPlugin.class.isAssignableFrom(type)) {
                answer = (PlatformHttpPlugin)this.camelContext.getInjector().newInstance(type, false);
                CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.camelContext);
            } else {
                throw new IllegalArgumentException("Resolving platform-http-plugin: " + id + " detected type conflict: Not a PlatformHttpPlugin implementation. Found: " + type.getName());
            }
        }
        return answer;
    }
}

