/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.support.CamelContextHelper;

public class VertxPlatformHttpRouter
implements Router {
    public static final String PLATFORM_HTTP_ROUTER_NAME = "platform-http-router";
    private final String name;
    private final VertxPlatformHttpServer server;
    private final Vertx vertx;
    private final Router delegate;
    private AllowForwardHeaders allowForward;

    public VertxPlatformHttpRouter(VertxPlatformHttpServer server, Vertx vertx, Router delegate, String name) {
        this.server = server;
        this.vertx = vertx;
        this.delegate = delegate;
        this.allowForward = AllowForwardHeaders.NONE;
        this.name = name;
    }

    public Vertx vertx() {
        return this.vertx;
    }

    public VertxPlatformHttpServer getServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    public Route route() {
        return this.delegate.route();
    }

    public Route route(HttpMethod method, String s) {
        return this.delegate.route(method, s);
    }

    public Route route(String s) {
        return this.delegate.route(s);
    }

    public Route routeWithRegex(HttpMethod method, String s) {
        return this.delegate.routeWithRegex(method, s);
    }

    public Route routeWithRegex(String s) {
        return this.delegate.routeWithRegex(s);
    }

    public Route get() {
        return this.delegate.get();
    }

    public Route get(String s) {
        return this.delegate.get(s);
    }

    public Route getWithRegex(String s) {
        return this.delegate.getWithRegex(s);
    }

    public Route head() {
        return this.delegate.head();
    }

    public Route head(String s) {
        return this.delegate.head(s);
    }

    public Route headWithRegex(String s) {
        return this.delegate.headWithRegex(s);
    }

    public Route options() {
        return this.delegate.options();
    }

    public Route options(String s) {
        return this.delegate.options(s);
    }

    public Route optionsWithRegex(String s) {
        return this.delegate.optionsWithRegex(s);
    }

    public Route put() {
        return this.delegate.put();
    }

    public Route put(String s) {
        return this.delegate.put(s);
    }

    public Route putWithRegex(String s) {
        return this.delegate.putWithRegex(s);
    }

    public Route post() {
        return this.delegate.post();
    }

    public Route post(String s) {
        return this.delegate.post(s);
    }

    public Route postWithRegex(String s) {
        return this.delegate.postWithRegex(s);
    }

    public Route delete() {
        return this.delegate.delete();
    }

    public Route delete(String s) {
        return this.delegate.delete(s);
    }

    public Route deleteWithRegex(String s) {
        return this.delegate.deleteWithRegex(s);
    }

    public Route trace() {
        return this.delegate.trace();
    }

    public Route trace(String s) {
        return this.delegate.trace(s);
    }

    public Route traceWithRegex(String s) {
        return this.delegate.traceWithRegex(s);
    }

    public Route connect() {
        return this.delegate.connect();
    }

    public Route connect(String s) {
        return this.delegate.connect(s);
    }

    public Route connectWithRegex(String s) {
        return this.delegate.connectWithRegex(s);
    }

    public Route patch() {
        return this.delegate.patch();
    }

    public Route patch(String s) {
        return this.delegate.patch(s);
    }

    public Route patchWithRegex(String s) {
        return this.delegate.patchWithRegex(s);
    }

    public List<Route> getRoutes() {
        return this.delegate.getRoutes();
    }

    public Router clear() {
        return this.delegate.clear();
    }

    public Route mountSubRouter(String mountPoint, Router subRouter) {
        if (mountPoint.endsWith("*")) {
            throw new IllegalArgumentException("Don't include * when mounting a sub router");
        }
        return this.route(mountPoint + "*").subRouter(subRouter);
    }

    public Router errorHandler(int i, Handler<RoutingContext> handler) {
        return this.delegate.errorHandler(i, handler);
    }

    public void handleContext(RoutingContext context) {
        this.delegate.handleContext(context);
    }

    public void handleFailure(RoutingContext context) {
        this.delegate.handleFailure(context);
    }

    public Router modifiedHandler(Handler<Router> handler) {
        return this.delegate.modifiedHandler(handler);
    }

    public Router allowForward(AllowForwardHeaders allowForwardHeaders) {
        this.allowForward = allowForwardHeaders;
        return this;
    }

    public void handle(HttpServerRequest request) {
        this.delegate.handle((Object)request);
    }

    public Router putMetadata(String key, Object value) {
        return this.delegate.putMetadata(key, value);
    }

    public Map<String, Object> metadata() {
        return this.delegate.metadata();
    }

    public Handler<RoutingContext> bodyHandler() {
        return BodyHandler.create();
    }

    public static VertxPlatformHttpRouter lookup(CamelContext camelContext, String routerName) {
        return (VertxPlatformHttpRouter)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)routerName, VertxPlatformHttpRouter.class);
    }

    @Deprecated
    public static VertxPlatformHttpRouter lookup(CamelContext camelContext) {
        return VertxPlatformHttpRouter.lookup(camelContext, VertxPlatformHttpRouter.getRouterNameFromPort(8080));
    }

    public static String getRouterNameFromPort(int port) {
        return "platform-http-router-" + port;
    }
}

