/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.vertx;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Processor;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.spi.PlatformHttpConsumer;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpConsumer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.service.ServiceSupport;

@JdkService(value="platform-http-engine")
public class VertxPlatformHttpEngine
extends ServiceSupport
implements PlatformHttpEngine,
CamelContextAware {
    private CamelContext camelContext;
    private List<Handler<RoutingContext>> handlers = Collections.emptyList();
    private int port;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public List<Handler<RoutingContext>> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void setHandlers(List<Handler<RoutingContext>> handlers) {
        if (handlers != null) {
            this.handlers = new ArrayList<Handler<RoutingContext>>(handlers);
        }
    }

    protected void doInit() throws Exception {
        super.doInit();
        this.camelContext.getRegistry().bind("platform-http-engine", PlatformHttpEngine.class, (Object)this);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public PlatformHttpConsumer createConsumer(PlatformHttpEndpoint endpoint, Processor processor) {
        return new VertxPlatformHttpConsumer(endpoint, processor, this.handlers);
    }

    public int getServerPort() {
        if (this.port == 0) {
            VertxPlatformHttpRouter router;
            VertxPlatformHttpServerConfiguration config;
            VertxPlatformHttpServer server = (VertxPlatformHttpServer)((Object)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, VertxPlatformHttpServer.class));
            if (server != null && server.getServer() != null) {
                this.port = server.getServer().actualPort();
            }
            if (this.port == 0 && (config = (VertxPlatformHttpServerConfiguration)CamelContextHelper.findSingleByType((CamelContext)this.camelContext, VertxPlatformHttpServerConfiguration.class)) != null) {
                this.port = config.getBindPort();
            }
            if (this.port == 0 && (router = VertxPlatformHttpRouter.lookup(this.camelContext)) != null && router.getServer() != null && router.getServer().getServer() != null) {
                this.port = router.getServer().getServer().actualPort();
            }
        }
        return this.port;
    }
}

