/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.main;

import io.vertx.core.Handler;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.BlockingHandlerDecorator;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Service;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.main.MainHttpServerUtil;
import org.apache.camel.component.platform.http.spi.PlatformHttpPluginRegistry;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpRouter;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServer;
import org.apache.camel.component.platform.http.vertx.VertxPlatformHttpServerConfiguration;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Camel Main Embedded HTTP server")
public class MainHttpServer
extends ServiceSupport
implements CamelContextAware,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(MainHttpServer.class);
    private VertxPlatformHttpServer server;
    private VertxPlatformHttpRouter router;
    private CamelContext camelContext;
    private PlatformHttpComponent platformHttpComponent;
    private VertxPlatformHttpServerConfiguration configuration = new VertxPlatformHttpServerConfiguration();
    private boolean staticEnabled;
    private String staticSourceDir;
    private String staticContextPath;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public VertxPlatformHttpServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(VertxPlatformHttpServerConfiguration configuration) {
        this.configuration = configuration;
    }

    @ManagedAttribute(description="Whether file uploads is enabled")
    public boolean isFileUploadEnabled() {
        return this.configuration.getBodyHandler().isHandleFileUploads();
    }

    public void setFileUploadEnabled(boolean fileUploadEnabled) {
        this.configuration.getBodyHandler().setHandleFileUploads(fileUploadEnabled);
    }

    @ManagedAttribute(description="Directory to temporary store file uploads")
    public String getFileUploadDirectory() {
        return this.configuration.getBodyHandler().getUploadsDirectory();
    }

    public void setFileUploadDirectory(String fileUploadDirectory) {
        this.configuration.getBodyHandler().setUploadsDirectory(fileUploadDirectory);
    }

    @ManagedAttribute(description="Whether serving static content is enabled (such as html pages)")
    public boolean isStaticEnabled() {
        return this.staticEnabled;
    }

    public void setStaticEnabled(boolean staticEnabled) {
        this.staticEnabled = staticEnabled;
    }

    public String getStaticSourceDir() {
        return this.staticSourceDir;
    }

    @ManagedAttribute(description="The source dir for serving static content")
    public void setStaticSourceDir(String staticSourceDir) {
        this.staticSourceDir = staticSourceDir;
    }

    @ManagedAttribute(description="The context-path for serving static content")
    public String getStaticContextPath() {
        return this.staticContextPath;
    }

    public void setStaticContextPath(String staticContextPath) {
        this.staticContextPath = staticContextPath;
    }

    @ManagedAttribute(description="Whether serving static content is enabled (such as html pages)")
    public boolean isStaticFilePattern() {
        return this.staticEnabled;
    }

    @ManagedAttribute(description="HTTP server port number")
    public int getPort() {
        return this.configuration.getBindPort();
    }

    public void setPort(int port) {
        this.configuration.setBindPort(port);
    }

    @ManagedAttribute(description="HTTP server hostname")
    public String getHost() {
        return this.configuration.getBindHost();
    }

    public void setHost(String host) {
        this.configuration.setBindHost(host);
    }

    @ManagedAttribute(description="HTTP server base path")
    public String getPath() {
        return this.configuration.getPath();
    }

    public void setPath(String path) {
        this.configuration.setPath(path);
    }

    @ManagedAttribute(description="HTTP server maximum body size")
    public Long getMaxBodySize() {
        return this.configuration.getMaxBodySize();
    }

    public void setMaxBodySize(Long maxBodySize) {
        this.configuration.setMaxBodySize(maxBodySize);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    @ManagedAttribute(description="HTTP server using global SSL context parameters")
    public boolean isUseGlobalSslContextParameters() {
        return this.configuration.isUseGlobalSslContextParameters();
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.configuration.setUseGlobalSslContextParameters(useGlobalSslContextParameters);
    }

    public VertxPlatformHttpServerConfiguration.Cors getCors() {
        return this.configuration.getCors();
    }

    public void setCors(VertxPlatformHttpServerConfiguration.Cors corsConfiguration) {
        this.configuration.setCors(corsConfiguration);
    }

    public VertxPlatformHttpServerConfiguration.BodyHandler getBodyHandler() {
        return this.configuration.getBodyHandler();
    }

    public void setBodyHandler(VertxPlatformHttpServerConfiguration.BodyHandler bodyHandler) {
        this.configuration.setBodyHandler(bodyHandler);
    }

    public VertxPlatformHttpRouter getRouter() {
        return this.router;
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        this.server = new VertxPlatformHttpServer(this.configuration);
        this.camelContext.addService((Object)this.server);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext");
        ServiceHelper.startService((Service)this.server);
        String routerName = VertxPlatformHttpRouter.getRouterNameFromPort((int)this.getPort());
        this.router = VertxPlatformHttpRouter.lookup((CamelContext)this.camelContext, (String)routerName);
        this.platformHttpComponent = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        this.setupConsoles();
        this.setupStartupSummary();
    }

    protected void setupConsoles() {
        if (this.staticEnabled) {
            this.setupStatic();
        }
    }

    protected void setupStatic() {
        Object path = this.staticContextPath;
        if (!((String)path).endsWith("*")) {
            path = (String)path + "*";
        }
        Route web = this.router.route((String)path);
        web.produces("*");
        web.consumes("*");
        web.order(Integer.MAX_VALUE);
        Handler<RoutingContext> handler = new Handler<RoutingContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(RoutingContext ctx) {
                String u = ctx.normalizedPath();
                u = u.isBlank() || u.endsWith("/") || u.equals("index.html") ? "index.html" : FileUtil.stripLeadingSeparator((String)u);
                InputStream is = null;
                File f = new File(u);
                if (!f.exists() && MainHttpServer.this.staticSourceDir != null) {
                    f = new File(MainHttpServer.this.staticSourceDir, u);
                }
                if (f.exists()) {
                    try {
                        is = new FileInputStream(f);
                    }
                    catch (Exception exception) {}
                } else {
                    is = MainHttpServer.this.camelContext.getClassResolver().loadResourceAsStream(u);
                    if (is == null) {
                        is = MainHttpServer.this.camelContext.getClassResolver().loadResourceAsStream("META-INF/resources/" + u);
                    }
                    if (is == null && MainHttpServer.this.staticSourceDir != null) {
                        is = MainHttpServer.this.camelContext.getClassResolver().loadResourceAsStream(MainHttpServer.this.staticSourceDir + "/" + u);
                    }
                }
                if (is != null) {
                    String mime = MimeMapping.getMimeTypeForFilename((String)f.getName());
                    if (mime != null) {
                        ctx.response().putHeader("content-type", mime);
                    }
                    String text = null;
                    try {
                        text = IOHelper.loadText((InputStream)is);
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        IOHelper.close((Closeable)is);
                    }
                    ctx.response().setStatusCode(200);
                    ctx.end(text);
                } else {
                    ctx.response().setStatusCode(404);
                    ctx.end();
                }
            }
        };
        web.handler((Handler)new BlockingHandlerDecorator((Handler)handler, true));
        this.platformHttpComponent.addHttpEndpoint(this.staticContextPath, null, null, null, null);
    }

    protected PlatformHttpPluginRegistry resolvePlatformHttpPluginRegistry() {
        Optional result = ResolverHelper.resolveService((CamelContext)this.getCamelContext(), (String)"platform-http/plugin-registry", PlatformHttpPluginRegistry.class);
        return (PlatformHttpPluginRegistry)result.orElseThrow(() -> new IllegalArgumentException("Cannot create PlatformHttpPluginRegistry. Make sure camel-platform-http JAR is on classpath."));
    }

    protected void setupStartupSummary() throws Exception {
        MainHttpServerUtil.setupStartupSummary(this.camelContext, this.platformHttpComponent.getHttpEndpoints(), this.server != null ? this.server.getPort() : this.getPort(), "HTTP endpoints summary");
    }
}

