/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone.transform;

import dev.langchain4j.data.embedding.Embedding;
import java.util.UUID;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="pinecone:embeddings", description="Prepares the message to become an object writable by Pinecone component")
public class PineconeEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) {
        Embedding embedding = (Embedding)message.getHeader("CamelLangChain4jEmbeddingsVector", Embedding.class);
        String indexId = (String)message.getHeader("CamelPineconeIndexId", (Object)UUID.randomUUID(), String.class);
        String indexName = (String)message.getHeader("CamelPineconeIndexName", (Object)"embeddings", String.class);
        message.setHeader("CamelPineconeIndexName", (Object)indexName);
        message.setHeader("CamelPineconeIndexId", (Object)indexId);
        message.setBody((Object)embedding.vectorAsList());
    }
}

