/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pinecone.transform;

import com.google.protobuf.Value;
import io.pinecone.unsigned_indices_model.ScoredVectorWithUnsignedIndices;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Message;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.DataTypeTransformer;
import org.apache.camel.spi.Transformer;

@DataTypeTransformer(name="pinecone:rag", description="Maps a List of retrieved LangChain4j Embeddings with similarity search to a List of String for LangChain4j RAG")
public class PineconeReverseEmbeddingsDataTypeTransformer
extends Transformer {
    public void transform(Message message, DataType fromType, DataType toType) throws Exception {
        List embeddings = (List)message.getBody(List.class);
        if (embeddings == null || embeddings.isEmpty()) {
            message.setBody(Collections.emptyList());
            return;
        }
        List result = embeddings.stream().map(ScoredVectorWithUnsignedIndices::getMetadata).map(metadata -> metadata.containsFields("text_segment") ? metadata.getFieldsOrDefault("text_segment", Value.getDefaultInstance()).getStringValue() : "").collect(Collectors.toList());
        message.setBody(result);
    }
}

