/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.camel.component.pdf.PdfConfiguration;
import org.apache.camel.component.pdf.text.LineBuilderStrategy;
import org.apache.camel.component.pdf.text.PdfUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public class DefaultLineBuilderStrategy
implements LineBuilderStrategy {
    private final PdfConfiguration pdfConfiguration;

    public DefaultLineBuilderStrategy(PdfConfiguration pdfConfiguration) {
        this.pdfConfiguration = pdfConfiguration;
    }

    @Override
    public Collection<String> buildLines(Collection<String> splittedText) throws IOException {
        LinkedList<String> wordsList = new LinkedList<String>(splittedText);
        ArrayList<String> lines = new ArrayList<String>();
        LineBuilder currentLine = new LineBuilder();
        float allowedLineWidth = this.getAllowedLineWidth();
        while (!wordsList.isEmpty()) {
            String word = wordsList.removeFirst();
            if (this.isWordFitInCurrentLine(currentLine, word, allowedLineWidth)) {
                currentLine.appendWord(word);
                if (!wordsList.isEmpty()) continue;
                lines.add(currentLine.buildLine());
                continue;
            }
            if (currentLine.getWordsCount() != 0) {
                lines.add(currentLine.buildLine());
                wordsList.addFirst(word);
                continue;
            }
            int splitIndex = this.findSplitIndex(word, allowedLineWidth);
            currentLine.appendWord(word.substring(0, splitIndex));
            lines.add(currentLine.buildLine());
            wordsList.addFirst(word.substring(splitIndex));
        }
        return lines;
    }

    private int findSplitIndex(String word, float allowedLineWidth) throws IOException {
        int middle = word.length() >> 1;
        int end = word.length();
        int currentSplitIndex = 0;
        do {
            if (this.isLineFitInLineWidth(word.substring(0, middle), allowedLineWidth)) {
                currentSplitIndex = middle;
                middle += word.substring(middle, end).length() >> 1;
                continue;
            }
            end = middle;
            middle = currentSplitIndex + (word.substring(currentSplitIndex, middle).length() >> 1);
        } while (currentSplitIndex == -1 || !this.isSplitIndexFound(word, allowedLineWidth, currentSplitIndex));
        return currentSplitIndex;
    }

    private boolean isSplitIndexFound(String word, float allowedLineWidth, int currentSplitIndex) throws IOException {
        return this.isLineFitInLineWidth(word.substring(0, currentSplitIndex), allowedLineWidth) && !this.isLineFitInLineWidth(word.substring(0, currentSplitIndex + 1), allowedLineWidth);
    }

    private boolean isWordFitInCurrentLine(LineBuilder currentLine, String word, float allowedLineWidth) throws IOException {
        LineBuilder lineBuilder = currentLine.clone().appendWord(word);
        return this.isLineFitInLineWidth(lineBuilder.buildLine(), allowedLineWidth);
    }

    private boolean isLineFitInLineWidth(String currentLine, float allowedLineWidth) throws IOException {
        float fontWidth = PdfUtils.getFontWidth(currentLine, (PDFont)new PDType1Font(Standard14Fonts.FontName.valueOf((String)this.pdfConfiguration.getFont())), this.pdfConfiguration.getFontSize());
        return fontWidth <= allowedLineWidth;
    }

    public float getAllowedLineWidth() {
        float result = this.pdfConfiguration.getPageSize().getWidth() - (float)this.pdfConfiguration.getMarginLeft() - (float)this.pdfConfiguration.getMarginRight();
        if (result < 20.0f) {
            throw new IllegalStateException(String.format("Allowed line width cannot be < %d, make sure (marginLeft + marginRight) < pageSize", 20));
        }
        return result;
    }

    private static final class LineBuilder {
        private StringBuilder line = new StringBuilder();
        private int wordsCount;

        LineBuilder() {
        }

        LineBuilder(String line, int wordsCount) {
            this.line = new StringBuilder(line);
            this.wordsCount = wordsCount;
        }

        public LineBuilder appendWord(String word) {
            this.line.append(word).append(" ");
            ++this.wordsCount;
            return this;
        }

        public String buildLine() {
            String savedLine = this.line.toString();
            this.reset();
            return savedLine;
        }

        public int getWordsCount() {
            return this.wordsCount;
        }

        private void reset() {
            this.line = new StringBuilder();
            this.wordsCount = 0;
        }

        public LineBuilder clone() {
            return new LineBuilder(this.line.toString(), this.wordsCount);
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }
}

