/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.io.FileFilter;
import java.io.IOError;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.dsl.DslHelper;
import org.apache.camel.maven.packaging.generics.JavadocUtil;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.util.JavadocHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.commons.text.CaseUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.build.BuildContext;

@Mojo(name="generate-endpoint-dsl", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class EndpointDslMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter(defaultValue="${project.basedir}")
    protected File baseDir;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint")
    protected String endpointFactoriesPackageName;
    @Parameter(defaultValue="org.apache.camel.builder.endpoint.dsl")
    protected String componentsFactoriesPackageName;
    @Parameter
    protected File sourcesOutputDir;
    @Parameter
    protected File componentsMetadata;
    @Parameter
    protected File outputResourcesDir;
    @Parameter(defaultValue="${project.basedir}/../../catalog/camel-catalog/src/generated/resources/org/apache/camel/catalog/components")
    protected File jsonDir;

    @Inject
    public EndpointDslMojo(MavenProjectHelper projectHelper, BuildContext buildContext) {
        super(projectHelper, buildContext);
    }

    @Override
    public void execute(MavenProject project) throws MojoFailureException, MojoExecutionException {
        this.buildDir = new File(project.getBuild().getDirectory());
        this.baseDir = project.getBasedir();
        this.endpointFactoriesPackageName = "org.apache.camel.builder.endpoint";
        this.componentsFactoriesPackageName = "org.apache.camel.builder.endpoint.dsl";
        super.execute(project);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File camelDir = PackageHelper.findCamelDirectory((File)this.baseDir, (String)"dsl/camel-endpointdsl");
        if (camelDir == null) {
            this.getLog().debug((CharSequence)"No dsl/camel-endpointdsl folder found, skipping execution");
            return;
        }
        Path root = camelDir.toPath();
        if (this.sourcesOutputDir == null) {
            this.sourcesOutputDir = root.resolve("src/generated/java").toFile();
        }
        if (this.outputResourcesDir == null) {
            this.outputResourcesDir = root.resolve("src/generated/resources").toFile();
        }
        if (this.componentsMetadata == null) {
            this.componentsMetadata = this.outputResourcesDir.toPath().resolve("metadata.json").toFile();
        }
        ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
        for (File file : this.jsonDir.listFiles()) {
            BaseModel model = JsonMapper.generateModel((Path)file.toPath());
            models.add((ComponentModel)model);
        }
        this.executeComponent(models);
    }

    private void executeComponent(List<ComponentModel> allModels) throws MojoFailureException {
        if (allModels.isEmpty()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Found " + allModels.size() + " components"));
        }
        Map models = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType, HashMap::new, Collectors.collectingAndThen(Collectors.toList(), l -> {
            l.sort(Comparator.comparingInt(o -> o.getAlternativeSchemes().indexOf(o.getScheme())));
            return l;
        })));
        for (List aliases : models.values()) {
            ComponentModel model = (ComponentModel)aliases.get(0);
            if (!this.doCreateEndpointDsl(model, aliases)) continue;
            this.getLog().info((CharSequence)("Updated EndpointDsl: " + model.getScheme()));
        }
        this.getLog().debug((CharSequence)"Load components EndpointFactories");
        List<File> endpointFactories = this.loadAllComponentsDslEndpointFactoriesAsFile();
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilderFactory");
        if (this.synchronizeEndpointBuilderFactoryInterface(endpointFactories)) {
            this.getLog().info((CharSequence)"UpdatedEndpointBuilderFactory ");
        }
        this.getLog().debug((CharSequence)"Regenerate EndpointBuilders");
        if (this.synchronizeEndpointBuildersInterface(endpointFactories)) {
            this.getLog().info((CharSequence)"Updated EndpointBuilders");
        }
        this.getLog().debug((CharSequence)"Regenerate StaticEndpointBuilders");
        if (this.synchronizeEndpointBuildersStaticClass(allModels, models)) {
            this.getLog().info((CharSequence)"Updated StaticEndpointBuilders");
        }
    }

    private boolean doCreateEndpointDsl(ComponentModel model, List<ComponentModel> aliases) throws MojoFailureException {
        String componentName = this.getComponentNameFromType(model.getJavaType());
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
        ctx.put("componentName", componentName);
        ctx.put("package", this.componentsFactoriesPackageName);
        ctx.put("model", model);
        ctx.put("aliases", aliases);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/endpoint-builder.vm", ctx);
        return this.writeSourceIfChanged(source, this.componentsFactoriesPackageName.replace('.', '/'), componentName + "EndpointBuilderFactory.java");
    }

    public String headerNameMethodName(String headerName) {
        Object name = headerName.chars().anyMatch(c -> c == 58 || c == 45 || c == 46 || c == 95) ? CaseUtils.toCamelCase((String)headerName, (boolean)false, (char[])new char[]{':', '-', '.', '_'}) : headerName.substring(0, 1).toLowerCase() + headerName.substring(1);
        return name;
    }

    public String createBaseDescription(BaseOptionModel option, String kind, boolean ignoreMultiValue, String optionDoc) {
        String baseDesc = option.getDescription();
        if (Strings.isEmpty((String)baseDesc)) {
            return baseDesc;
        }
        baseDesc = JavadocHelper.xmlEncode((String)baseDesc);
        StringBuilder baseDescBuilder = new StringBuilder(baseDesc);
        if (!baseDesc.endsWith(".")) {
            baseDescBuilder.append(".");
        }
        if (option.isSupportFileReference()) {
            baseDescBuilder.append("\n");
            baseDescBuilder.append("\nThis option can also be loaded from an existing file, by prefixing with file: or classpath: followed by the location of the file.");
        }
        baseDescBuilder.append("\n").append(optionDoc);
        if (option.isMultiValue()) {
            baseDescBuilder.append("\nThe option is multivalued, and you can use the ").append(option.getName()).append("(String, Object) method to add a value (call the method multiple times to set more values).");
        }
        baseDescBuilder.append("\n");
        if (kind.equals(option.getKind()) && option.isRequired()) {
            baseDescBuilder.append("\nRequired: true");
        }
        if (option.getDefaultValue() != null) {
            String value = JavadocHelper.xmlEncode((String)option.getDefaultValue().toString());
            baseDescBuilder.append("\nDefault: ").append(value);
        }
        baseDescBuilder.append("\nGroup: ").append(option.getGroup());
        return baseDescBuilder.toString();
    }

    public String optionJavaType(ComponentModel.EndpointOptionModel option) {
        String answer = option.getJavaType();
        if (answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        if (answer.startsWith("java.util.concurrent.")) {
            return answer.substring(21);
        }
        if (answer.startsWith("java.util.function.")) {
            return answer.substring(19);
        }
        if (answer.startsWith("java.util.stream.")) {
            return answer.substring(17);
        }
        if (answer.startsWith("java.util.")) {
            return answer.substring(10);
        }
        return answer;
    }

    private boolean synchronizeEndpointBuilderFactoryInterface(List<File> factories) throws MojoFailureException {
        List<String> factoryNames = factories.stream().map(factory -> {
            String factoryName = Strings.before((String)factory.getName(), (String)".");
            String endpointsName = factoryName.replace("EndpointBuilderFactory", "Builders");
            return this.componentsFactoriesPackageName + "." + factoryName + "." + endpointsName;
        }).toList();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
        ctx.put("package", this.endpointFactoriesPackageName);
        ctx.put("className", "EndpointBuilderFactory");
        ctx.put("factories", factoryNames);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/endpoint-builder-factory.vm", ctx);
        return this.writeSourceIfChanged(source, this.endpointFactoriesPackageName.replace('.', '/'), "EndpointBuilderFactory.java");
    }

    private boolean synchronizeEndpointBuildersInterface(List<File> factories) throws MojoFailureException {
        List<String> factoryNames = factories.stream().map(factory -> {
            String factoryName = Strings.before((String)factory.getName(), (String)".");
            return this.componentsFactoriesPackageName + "." + factoryName;
        }).toList();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
        ctx.put("package", this.endpointFactoriesPackageName);
        ctx.put("className", "EndpointBuilders");
        ctx.put("factories", factoryNames);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/endpoint-builders.vm", ctx);
        return this.writeSourceIfChanged(source, this.endpointFactoriesPackageName.replace(".", "/"), "EndpointBuilders.java");
    }

    private boolean synchronizeEndpointBuildersStaticClass(List<ComponentModel> allModels, Map<String, List<ComponentModel>> models) throws MojoFailureException {
        ArrayList<ComponentModel> sortedModels = new ArrayList<ComponentModel>(allModels);
        sortedModels.sort(Comparator.comparing(ComponentModel::getScheme));
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("generatorClass", ((Object)((Object)this)).getClass().getName());
        ctx.put("package", this.endpointFactoriesPackageName);
        ctx.put("dslPackage", this.componentsFactoriesPackageName);
        ctx.put("className", "StaticEndpointBuilders");
        ctx.put("models", models);
        ctx.put("sortedModels", sortedModels);
        ctx.put("mojo", (Object)this);
        String source = this.velocity("velocity/endpoint-static-builders.vm", ctx);
        return this.writeSourceIfChanged(source, this.endpointFactoriesPackageName.replace(".", "/"), "StaticEndpointBuilders.java");
    }

    private List<File> loadAllComponentsDslEndpointFactoriesAsFile() {
        FileFilter fileFilter;
        File allComponentsDslEndpointFactory = new File(this.sourcesOutputDir, this.componentsFactoriesPackageName.replace('.', '/'));
        File[] files = allComponentsDslEndpointFactory.listFiles(fileFilter = file -> file.isFile() && file.getName().endsWith(".java"));
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(files).sorted().toList();
    }

    public String camelCaseLower(String s) {
        int i;
        while (s != null && (i = ((String)s).indexOf(45)) > 0) {
            s = EndpointDslMojo.camelCaseAtIndex((String)s, i);
        }
        while (s != null && (i = ((String)s).indexOf(43)) > 0) {
            s = EndpointDslMojo.camelCaseAtIndex((String)s, i);
        }
        if (s != null) {
            s = ((String)s).substring(0, 1).toLowerCase() + ((String)s).substring(1);
            s = DslHelper.sanitizeText((String)s);
        }
        return s;
    }

    private static String camelCaseAtIndex(String s, int i) {
        return s.substring(0, i) + Strings.capitalize((String)s.substring(i + 1));
    }

    public String getComponentNameFromType(String type) {
        int pos = type.lastIndexOf(46);
        String name = type.substring(pos + 1).replace("Component", "");
        return switch (type) {
            case "org.apache.camel.component.atmosphere.websocket.WebsocketComponent" -> "AtmosphereWebsocket";
            case "org.apache.camel.component.zookeepermaster.MasterComponent" -> "ZooKeeperMaster";
            case "org.apache.camel.component.elasticsearch.ElasticsearchComponent" -> "ElasticsearchRest";
            case "org.apache.camel.component.activemq.ActiveMQComponent" -> "ActiveMQ";
            case "org.apache.camel.component.activemq6.ActiveMQComponent" -> "ActiveMQ6";
            default -> name;
        };
    }

    private String getEndpointName(String type) {
        return this.getComponentNameFromType(type) + "EndpointBuilder";
    }

    private boolean writeSourceIfChanged(String code, String filePath, String fileName) throws MojoFailureException {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            }
            return this.updateResource(this.sourcesOutputDir.toPath(), filePath + "/" + fileName, code);
        }
        catch (IOError e) {
            throw new MojoFailureException("IOError with file " + filePath + "/" + fileName, (Throwable)e);
        }
    }

    public String getMainDescription(ComponentModel model) {
        return JavadocUtil.getMainDescription(model, true);
    }

    public String getMainDescription(ComponentModel model, boolean withPathParameterDetails) {
        return JavadocUtil.getMainDescription(model, withPathParameterDetails);
    }

    public String pathParameterJavaDoc(ComponentModel model) {
        return JavadocUtil.pathParameterJavaDoc(model);
    }

    public String xmlEncode(String str) {
        return JavadocHelper.xmlEncode((String)str);
    }

    public String javadoc(String indent, String doc) {
        StringBuilder sb = new StringBuilder(doc.length() * 2);
        List<String> lines = this.formatJavadocOrCommentStringAsList(doc, indent);
        if (!lines.isEmpty()) {
            sb.append("/**\n");
            for (String line : lines) {
                sb.append(indent).append(" * ").append(line).append("\n");
            }
            sb.append(indent).append(" */");
        }
        return sb.toString();
    }

    private List<String> formatJavadocOrCommentStringAsList(String text, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        int len = 78 - indent.length();
        String rem = text;
        if (rem != null) {
            while (!rem.isEmpty()) {
                int idx = rem.length() >= len ? rem.substring(0, len).lastIndexOf(32) : -1;
                int idx2 = rem.indexOf(10);
                if (idx2 >= 0 && (idx < 0 || idx2 < idx || idx2 < len)) {
                    idx = idx2;
                }
                if (idx >= 0) {
                    String s = rem.substring(0, idx);
                    while (s.endsWith(" ")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    String l = rem.substring(idx + 1);
                    while (l.startsWith(" ")) {
                        l = l.substring(1);
                    }
                    lines.add(s);
                    rem = l;
                    continue;
                }
                lines.add(rem);
                rem = "";
            }
        }
        return lines;
    }
}

