/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.util.Comparator;
import java.util.Objects;
import org.apache.camel.tooling.model.BaseOptionModel;
import org.apache.camel.tooling.util.Strings;

public final class EndpointHelper {
    private EndpointHelper() {
    }

    public static String labelAsGroupName(String label, boolean consumerOnly, boolean producerOnly) {
        String answer = "common";
        if (consumerOnly) {
            answer = "consumer";
        } else if (producerOnly) {
            answer = "producer";
        }
        String value = label;
        if (!Strings.isNullOrEmpty((String)value)) {
            if (value.contains("advanced")) {
                value = value.replaceFirst("(\\w),(advanced)", "$1 (advanced)");
            }
            if (value.contains(",")) {
                String[] array = value.split(",");
                answer = array[array.length - 1];
            } else {
                answer = value;
            }
        }
        return answer;
    }

    public static Comparator<BaseOptionModel> createGroupAndLabelComparator() {
        return new EndpointOptionGroupAndLabelComparator();
    }

    public static Comparator<BaseOptionModel> createPathComparator(String syntax) {
        return new EndpointPathComparator(syntax);
    }

    public static Comparator<BaseOptionModel> createOverallComparator(String syntax) {
        Comparator<BaseOptionModel> pathComparator = EndpointHelper.createPathComparator(syntax);
        Comparator<BaseOptionModel> groupAndLabelComparator = EndpointHelper.createGroupAndLabelComparator();
        return (o1, o2) -> {
            if (Objects.equals("path", o1.getKind())) {
                if (Objects.equals("path", o2.getKind())) {
                    return pathComparator.compare((BaseOptionModel)o1, (BaseOptionModel)o2);
                }
                return -1;
            }
            if (Objects.equals("path", o2.getKind())) {
                return 1;
            }
            return groupAndLabelComparator.compare((BaseOptionModel)o1, (BaseOptionModel)o2);
        };
    }

    private static int groupScore(String group) {
        switch (group) {
            case "common": {
                return 1;
            }
            case "common (advanced)": {
                return 2;
            }
            case "consumer": {
                return 3;
            }
            case "consumer (advanced)": {
                return 4;
            }
            case "producer": {
                return 5;
            }
            case "producer (advanced)": {
                return 6;
            }
        }
        return 9;
    }

    private static final class EndpointOptionGroupAndLabelComparator
    implements Comparator<BaseOptionModel> {
        private EndpointOptionGroupAndLabelComparator() {
        }

        @Override
        public int compare(BaseOptionModel o1, BaseOptionModel o2) {
            int score2;
            String name1 = o1.getName();
            String name2 = o2.getName();
            String label1 = !Strings.isNullOrEmpty((String)o1.getLabel()) ? o1.getLabel() : "common";
            String label2 = !Strings.isNullOrEmpty((String)o2.getLabel()) ? o2.getLabel() : "common";
            String group1 = o1.getGroup();
            String group2 = o2.getGroup();
            if (label1.equalsIgnoreCase(label2) || group1.equalsIgnoreCase(group2)) {
                return name1.compareToIgnoreCase(name2);
            }
            int score1 = EndpointHelper.groupScore(group1);
            if (score1 < (score2 = EndpointHelper.groupScore(group2))) {
                return -1;
            }
            if (score2 < score1) {
                return 1;
            }
            int score = group1.compareToIgnoreCase(group2);
            if (score == 0 && (score = label1.compareToIgnoreCase(label2)) == 0) {
                score = name1.compareToIgnoreCase(name2);
            }
            return score;
        }
    }

    private static final class EndpointPathComparator
    implements Comparator<BaseOptionModel> {
        private final String syntax;

        EndpointPathComparator(String syntax) {
            this.syntax = syntax;
        }

        @Override
        public int compare(BaseOptionModel path1, BaseOptionModel path2) {
            int pos2;
            int pos1 = this.syntax != null ? this.syntax.indexOf(path1.getName()) : -1;
            int n = pos2 = this.syntax != null ? this.syntax.indexOf(path2.getName()) : -1;
            if (pos1 != -1 && pos2 != -1) {
                return Integer.compare(pos1, pos2);
            }
            return 0;
        }
    }
}

