/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.maven.packaging.ErrorDetail;
import org.apache.camel.maven.packaging.ValidateHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="validate-components", threadSafe=true)
public class ValidateComponentMojo
extends AbstractGeneratorMojo {
    @Parameter(defaultValue="true")
    protected Boolean validate;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.validate == null) {
            this.validate = true;
        }
        if (this.outDir == null) {
            this.outDir = new File(this.project.getBuild().getOutputDirectory());
        }
        if (!this.validate.booleanValue()) {
            this.getLog().info((CharSequence)"Validation disabled");
        } else {
            List jsonFiles = PackageHelper.findJsonFiles((Path)this.outDir.toPath()).collect(Collectors.toList());
            boolean failed = false;
            for (Path file : jsonFiles) {
                String name = PackageHelper.asName((Path)file);
                ErrorDetail detail = new ErrorDetail();
                this.getLog().debug((CharSequence)("Validating file " + file));
                ValidateHelper.validate(file.toFile(), detail);
                if (!detail.hasErrors()) continue;
                failed = true;
                this.getLog().warn((CharSequence)("The " + detail.getKind() + ": " + name + " has validation errors"));
                if (detail.isMissingDescription()) {
                    this.getLog().warn((CharSequence)("Missing description on: " + detail.getKind()));
                }
                if (detail.isMissingLabel()) {
                    this.getLog().warn((CharSequence)("Missing label on: " + detail.getKind()));
                }
                if (detail.isMissingSyntax()) {
                    this.getLog().warn((CharSequence)"Missing syntax on endpoint");
                }
                if (detail.isMissingUriPath()) {
                    this.getLog().warn((CharSequence)"Missing @UriPath on endpoint");
                }
                if (!detail.getMissingComponentDocumentation().isEmpty()) {
                    this.getLog().warn((CharSequence)("Missing component documentation for the following options:" + Strings.indentCollection((String)"\n\t", detail.getMissingComponentDocumentation())));
                }
                if (detail.getMissingEndpointDocumentation().isEmpty()) continue;
                this.getLog().warn((CharSequence)("Missing endpoint documentation for the following options:" + Strings.indentCollection((String)"\n\t", detail.getMissingEndpointDocumentation())));
            }
            if (failed) {
                throw new MojoFailureException("Validating failed, see errors above!");
            }
            this.getLog().info((CharSequence)"Validation complete");
        }
    }
}

