/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.packaging;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import org.apache.camel.tooling.model.BaseOptionModel;

public final class PropertyConfigurerGenerator {
    private PropertyConfigurerGenerator() {
    }

    public static void generatePropertyConfigurer(String pn, String cn, String en, String pfqn, String psn, boolean hasSuper, Collection<? extends BaseOptionModel> options, Writer w) throws IOException {
        w.write("/* Generated by camel build tools - do NOT edit this file! */\n");
        w.write("package " + pn + ";\n");
        w.write("\n");
        w.write("import org.apache.camel.CamelContext;\n");
        w.write("import org.apache.camel.spi.GeneratedPropertyConfigurer;\n");
        w.write("import " + pfqn + ";\n");
        w.write("\n");
        w.write("/**\n");
        w.write(" * Generated by camel build tools - do NOT edit this file!\n");
        w.write(" */\n");
        w.write("@SuppressWarnings(\"unchecked\")\n");
        w.write("public class " + cn + " extends " + psn + " implements GeneratedPropertyConfigurer {\n");
        w.write("\n");
        if (!options.isEmpty() || !hasSuper) {
            w.write("    @Override\n");
            w.write("    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {\n");
            if (!options.isEmpty()) {
                w.write("        " + en + " target = (" + en + ") obj;\n");
                w.write("        switch (ignoreCase ? name.toLowerCase() : name) {\n");
                for (BaseOptionModel baseOptionModel : options) {
                    String getOrSet = baseOptionModel.getName();
                    getOrSet = Character.toUpperCase(getOrSet.charAt(0)) + getOrSet.substring(1);
                    String setterLambda = PropertyConfigurerGenerator.setterLambda(getOrSet, baseOptionModel.getJavaType(), baseOptionModel.getConfigurationField());
                    if (!baseOptionModel.getName().toLowerCase().equals(baseOptionModel.getName())) {
                        w.write(String.format("        case \"%s\":\n", baseOptionModel.getName().toLowerCase()));
                    }
                    w.write(String.format("        case \"%s\": %s; return true;\n", baseOptionModel.getName(), setterLambda));
                }
                if (hasSuper) {
                    w.write("        default: return super.configure(camelContext, obj, name, value, ignoreCase);\n");
                } else {
                    w.write("        default: return false;\n");
                }
                w.write("        }\n");
            }
            w.write("    }\n");
        }
        w.write("\n");
        w.write("}\n");
        w.write("\n");
    }

    private static String setterLambda(String getOrSet, String type, String configurationField) {
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        getOrSet = configurationField != null ? "get" + Character.toUpperCase(configurationField.charAt(0)) + configurationField.substring(1) + "().set" + getOrSet : "set" + getOrSet;
        return String.format("target.%s(property(camelContext, %s.class, value))", getOrSet, type);
    }
}

