/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator.client;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.SimpleValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import io.swagger.v3.oas.models.OpenAPI;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.spi.RestClientRequestValidator;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;

@JdkService(value="rest-client-validator-factory")
public class OpenApiRestClientRequestValidator
implements RestClientRequestValidator {
    public RestClientRequestValidator.ValidationError validate(Exchange exchange, RestClientRequestValidator.ValidationContext validationContent) {
        OpenApiInteractionValidator validator;
        ValidationReport report;
        OpenAPI openAPI = (OpenAPI)exchange.getProperty("CamelRestOpenAPI", OpenAPI.class);
        if (openAPI == null) {
            return null;
        }
        String method = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class);
        String path = (String)exchange.getMessage().getHeader("CamelHttpPath", String.class);
        String accept = (String)exchange.getMessage().getHeader("Accept", String.class);
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        String body = MessageHelper.extractBodyAsString((Message)exchange.getIn());
        SimpleRequest.Builder builder = new SimpleRequest.Builder(method, path, false);
        if (contentType != null) {
            builder.withContentType(contentType);
        }
        if (accept != null) {
            builder.withAccept(new String[]{accept});
        }
        if (body != null) {
            builder.withBody(body);
        }
        if ((report = (validator = OpenApiInteractionValidator.createFor((OpenAPI)openAPI).build()).validateRequest((Request)builder.build())).hasErrors()) {
            String msg = accept != null && accept.contains("application/json") ? JsonValidationReportFormat.getInstance().apply(report) : SimpleValidationReportFormat.getInstance().apply(report);
            return new RestClientRequestValidator.ValidationError(400, msg);
        }
        return null;
    }
}

