/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.openapi.validator.client;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleResponse;
import com.atlassian.oai.validator.report.JsonValidationReportFormat;
import com.atlassian.oai.validator.report.LevelResolver;
import com.atlassian.oai.validator.report.SimpleValidationReportFormat;
import com.atlassian.oai.validator.report.ValidationReport;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.rest.openapi.RestOpenApiComponent;
import org.apache.camel.component.rest.openapi.RestOpenApiHelper;
import org.apache.camel.http.base.HttpHeaderFilterStrategy;
import org.apache.camel.spi.RestClientResponseValidator;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="rest-client-response-validator-factory")
public class OpenApiRestClientResponseValidator
implements RestClientResponseValidator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRestClientResponseValidator.class);
    private final HttpHeaderFilterStrategy filter = new HttpHeaderFilterStrategy();

    public OpenApiRestClientResponseValidator() {
        this.filter.getOutFilter().add("accept");
        this.filter.getOutFilter().add("authorization");
        this.filter.getOutFilter().add("content-encoding");
        this.filter.getOutFilter().add("cookie");
        this.filter.getOutFilter().add("origin");
        this.filter.getOutFilter().add("user-agent");
        this.filter.getOutFilter().add("content-type");
    }

    public RestClientResponseValidator.ValidationError validate(Exchange exchange, RestClientResponseValidator.ValidationContext validationContent) {
        OpenApiInteractionValidator validator;
        ValidationReport validationReport;
        OpenAPI openAPI = (OpenAPI)exchange.getProperty("CamelRestOpenAPI", OpenAPI.class);
        if (openAPI == null) {
            return null;
        }
        String method = (String)exchange.getMessage().getHeader("CamelHttpMethod", String.class);
        String path = (String)exchange.getMessage().getHeader("CamelHttpPath", String.class);
        RestOpenApiComponent comp = (RestOpenApiComponent)exchange.getContext().hasComponent("rest-openapi");
        String basePath = RestOpenApiHelper.determineBasePath((CamelContext)exchange.getContext(), (RestOpenApiComponent)comp, null, (OpenAPI)openAPI);
        if (path != null && path.startsWith(basePath)) {
            path = path.substring(basePath.length());
        }
        if (path == null) {
            path = "/";
        }
        String accept = (String)exchange.getMessage().getHeader("Accept", String.class);
        String contentType = ExchangeHelper.getContentType((Exchange)exchange);
        String body = MessageHelper.extractBodyAsString((Message)exchange.getIn());
        int status = (Integer)exchange.getMessage().getHeader("CamelHttpResponseCode", (Object)200, Integer.TYPE);
        SimpleResponse.Builder builder = new SimpleResponse.Builder(status);
        if (contentType != null) {
            builder.withContentType(contentType);
        }
        if (body != null) {
            builder.withBody(body);
        }
        for (Map.Entry header : exchange.getMessage().getHeaders().entrySet()) {
            String key = (String)header.getKey();
            Object v = header.getValue();
            boolean customHeader = !OpenApiRestClientResponseValidator.startsWithIgnoreCase(key, "Camel") && !this.filter.applyFilterToCamelHeaders(key, v, exchange);
            if (!customHeader) continue;
            builder.withHeader(key, new String[]{(String)exchange.getMessage().getHeader(key, String.class)});
        }
        LevelResolver.Builder lr = LevelResolver.create();
        RestConfiguration rc = exchange.getContext().getRestConfiguration();
        if (rc.getValidationLevels() != null) {
            for (Map.Entry entry : rc.getValidationLevels().entrySet()) {
                String key = (String)entry.getKey();
                ValidationReport.Level level = ValidationReport.Level.valueOf((String)((String)entry.getValue()));
                if ("defaultLevel".equalsIgnoreCase(key)) {
                    lr.withDefaultLevel(level);
                    continue;
                }
                lr.withLevel(key, level);
            }
        }
        if ((validationReport = (validator = OpenApiInteractionValidator.createFor((OpenAPI)openAPI).withLevelResolver(lr.build()).build()).validateResponse(path, OpenApiRestClientResponseValidator.asMethod(method), (Response)builder.build())).hasErrors() || LOG.isDebugEnabled()) {
            String msg = accept != null && accept.contains("application/json") ? JsonValidationReportFormat.getInstance().apply(validationReport) : SimpleValidationReportFormat.getInstance().apply(validationReport);
            LOG.debug("Client Request Validation: {}", (Object)msg);
            if (validationReport.hasErrors()) {
                return new RestClientResponseValidator.ValidationError(500, msg);
            }
        }
        return null;
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        return s.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static Request.Method asMethod(String method) {
        return switch (method) {
            case "POST" -> Request.Method.POST;
            case "PUT" -> Request.Method.PUT;
            case "PATCH" -> Request.Method.PATCH;
            case "DELETE" -> Request.Method.DELETE;
            case "HEAD" -> Request.Method.HEAD;
            case "OPTIONS" -> Request.Method.OPTIONS;
            case "TRACE" -> Request.Method.TRACE;
            default -> Request.Method.GET;
        };
    }
}

