/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.openapi;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.generator.openapi.CodeEmitter;
import org.apache.camel.generator.openapi.DestinationGenerator;
import org.apache.camel.generator.openapi.OperationFilter;
import org.apache.camel.model.rest.CollectionFormat;
import org.apache.camel.model.rest.RestParamType;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

class OperationVisitor<T> {
    private final DestinationGenerator destinationGenerator;
    private final CodeEmitter<T> emitter;
    private final OperationFilter filter;
    private final String path;
    private final String dtoPackageName;

    OperationVisitor(CodeEmitter<T> emitter, OperationFilter filter, String path, DestinationGenerator destinationGenerator, String dtoPackageName) {
        this.emitter = emitter;
        this.filter = filter;
        this.path = path;
        this.destinationGenerator = destinationGenerator;
        this.dtoPackageName = dtoPackageName;
    }

    List<String> asStringList(List<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>();
        values.forEach(v -> {
            String s = String.valueOf(v);
            s = StringHelper.removeLeadingAndEndingQuotes((String)s);
            stringList.add(s);
        });
        return stringList;
    }

    CodeEmitter<T> emit(Parameter parameter) {
        Schema schema;
        this.emitter.emit("param", new Object[0]);
        this.emit("name", parameter.getName());
        String parameterType = parameter.getIn();
        if (ObjectHelper.isNotEmpty((String)parameterType)) {
            this.emit("type", RestParamType.valueOf((String)parameterType));
        }
        if (!"body".equals(parameterType) && (schema = parameter.getSchema()) != null) {
            String dataType = schema.getType();
            if (ObjectHelper.isNotEmpty((String)dataType)) {
                this.emit("dataType", dataType);
            }
            this.emit("allowableValues", this.asStringList(schema.getEnum()));
            Parameter.StyleEnum style = parameter.getStyle();
            if (ObjectHelper.isNotEmpty((Object)style) && style.equals((Object)Parameter.StyleEnum.FORM)) {
                if (Boolean.FALSE.equals(parameter.getExplode())) {
                    this.emit("collectionFormat", CollectionFormat.csv);
                } else {
                    this.emit("collectionFormat", CollectionFormat.multi);
                }
            }
            if (ObjectHelper.isNotEmpty((Object)schema.getDefault())) {
                String value = StringHelper.removeLeadingAndEndingQuotes((String)schema.getDefault().toString());
                this.emit("defaultValue", value);
            }
            if ("array".equals(dataType) && schema.getItems() != null) {
                this.emit("arrayType", schema.getItems().getType());
            }
        }
        if (parameter.getRequired() != null) {
            this.emit("required", parameter.getRequired());
        } else {
            this.emit("required", Boolean.FALSE);
        }
        this.emit("description", parameter.getDescription());
        this.emitter.emit("endParam", new Object[0]);
        return this.emitter;
    }

    CodeEmitter<T> emit(String method, Collection<String> values) {
        if (values == null || values.isEmpty()) {
            return this.emitter;
        }
        return this.emitter.emit(method, new Object[]{values.toArray(new String[0])});
    }

    CodeEmitter<T> emit(String method, Object value) {
        if (ObjectHelper.isEmpty((Object)value)) {
            return this.emitter;
        }
        return this.emitter.emit(method, value);
    }

    void visit(PathItem.HttpMethod method, Operation operation, PathItem pathItem) {
        if (this.filter.accept(operation.getOperationId())) {
            String methodName = method.name().toLowerCase();
            this.emitter.emit(methodName, this.path);
            this.emit("id", operation.getOperationId());
            this.emit("description", operation.getDescription());
            LinkedHashSet<String> operationLevelConsumes = new LinkedHashSet<String>();
            if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                operationLevelConsumes.addAll(operation.getRequestBody().getContent().keySet());
            }
            this.emit("consumes", operationLevelConsumes);
            LinkedHashSet<String> operationLevelProduces = new LinkedHashSet<String>();
            if (operation.getResponses() != null) {
                for (ApiResponse response : operation.getResponses().values()) {
                    if (response.getContent() == null) continue;
                    operationLevelProduces.addAll(response.getContent().keySet());
                }
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)"default");
                if (response != null && response.getContent() != null) {
                    operationLevelProduces.addAll(response.getContent().keySet());
                }
            }
            this.emit("produces", operationLevelProduces);
            if (ObjectHelper.isNotEmpty((Collection)operation.getParameters())) {
                operation.getParameters().forEach(this::emit);
            }
            if (ObjectHelper.isNotEmpty((Collection)pathItem.getParameters())) {
                pathItem.getParameters().forEach(this::emit);
            }
            this.emitOperation(operation);
            this.emitter.emit("to", this.destinationGenerator.generateDestinationFor(operation));
        }
    }

    private CodeEmitter<T> emitOperation(Operation operation) {
        Schema schema;
        String ref;
        Object dto;
        if (operation.getRequestBody() != null) {
            dto = null;
            boolean foundForm = false;
            RequestBody requestBody = operation.getRequestBody();
            for (Map.Entry entry : requestBody.getContent().entrySet()) {
                boolean isArray;
                String ct = (String)entry.getKey();
                MediaType mt = (MediaType)entry.getValue();
                if (ct.contains("form") && mt.getSchema().getProperties() != null) {
                    Set entrySet = mt.getSchema().getProperties().entrySet();
                    for (Map.Entry entrySchema : entrySet) {
                        Schema openApi31Schema = (Schema)entrySchema.getValue();
                        foundForm = true;
                        this.emitter.emit("param", new Object[0]);
                        this.emit("name", entrySchema.getKey());
                        this.emit("type", RestParamType.formData);
                        this.emit("dataType", openApi31Schema.getType());
                        this.emit("required", requestBody.getRequired());
                        this.emit("description", ((Schema)entrySchema.getValue()).getDescription());
                        this.emitter.emit("endParam", new Object[0]);
                    }
                }
                if (dto != null || (ref = (isArray = "array".equals((schema = mt.getSchema()).getType())) ? schema.getItems().get$ref() : schema.get$ref()) == null || !ref.startsWith("#/components/schemas/")) continue;
                dto = ref.substring(21);
                if (!isArray) continue;
                dto = (String)dto + "[]";
            }
            if (!foundForm) {
                this.emitter.emit("param", new Object[0]);
                this.emit("name", "body");
                this.emit("type", RestParamType.valueOf((String)"body"));
                this.emit("required", Boolean.TRUE);
                this.emit("description", requestBody.getDescription());
                this.emitter.emit("endParam", new Object[0]);
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("type", this.dtoPackageName + "." + dto);
            }
        }
        if (operation.getResponses() != null) {
            dto = null;
            for (String key : operation.getResponses().keySet()) {
                if (!"200".equals(key)) continue;
                ApiResponse response = (ApiResponse)operation.getResponses().get((Object)key);
                for (Map.Entry entry : response.getContent().entrySet()) {
                    boolean isArray;
                    MediaType mediaType = (MediaType)entry.getValue();
                    if (dto != null || (ref = (isArray = "array".equals((schema = mediaType.getSchema()).getType())) ? schema.getItems().get$ref() : schema.get$ref()) == null || !ref.startsWith("#/components/schemas/")) continue;
                    dto = ref.substring(21);
                    if (!isArray) continue;
                    dto = (String)dto + "[]";
                }
            }
            if (this.dtoPackageName != null && dto != null) {
                this.emit("outType", this.dtoPackageName + "." + dto);
            }
        }
        return this.emitter;
    }
}

