/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.util.Map;
import org.apache.camel.tooling.util.Version;

public class BeanConfig {
    public static final String DEFAULT_MEDIA_TYPE = "application/json";
    public static final Version OPENAPI_VERSION_30 = new Version("3.0.0");
    public static final Version OPENAPI_VERSION_31 = new Version("3.1.0");
    String[] schemes;
    String title;
    Version version = new Version("3.0.1");
    String licenseUrl;
    String license;
    Info info;
    String host;
    String basePath;
    String defaultConsumes = "application/json";
    String defaultProduces = "application/json";

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version.toString();
    }

    public void setVersion(String version) {
        this.version = new Version(version);
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        if (basePath != null && !basePath.isEmpty()) {
            this.basePath = !basePath.startsWith("/") ? "/" + basePath : basePath;
        }
    }

    public String getDefaultConsumes() {
        return this.defaultConsumes;
    }

    public void setDefaultConsumes(String defaultConsumes) {
        this.defaultConsumes = defaultConsumes;
    }

    public String getDefaultProduces() {
        return this.defaultProduces;
    }

    public void setDefaultProduces(String defaultProduces) {
        this.defaultProduces = defaultProduces;
    }

    public OpenAPI configure(OpenAPI openApi) {
        Map schemas;
        if (this.info != null) {
            openApi.setInfo(this.info);
        }
        for (String scheme : this.schemes) {
            String url = scheme + "://" + this.host;
            if (this.basePath != null) {
                url = this.basePath.startsWith("/") ? url + this.basePath : url + "/" + this.basePath;
            }
            Server server = new Server().url(url);
            openApi.addServersItem(server);
        }
        if (this.isOpenApi31() && openApi.getComponents() != null && (schemas = openApi.getComponents().getSchemas()) != null) {
            for (Schema schema : schemas.values()) {
                String type;
                if (!(schema instanceof ComposedSchema) || (type = schema.getType()) == null) continue;
                schema.addType(type);
            }
        }
        return openApi;
    }

    public boolean isOpenApi2() {
        return this.version.compareTo(OPENAPI_VERSION_30) < 0;
    }

    public boolean isOpenApi30() {
        return this.version.compareTo(OPENAPI_VERSION_30) >= 0 && this.version.compareTo(OPENAPI_VERSION_31) < 0;
    }

    public boolean isOpenApi31() {
        return this.version.compareTo(OPENAPI_VERSION_31) >= 0;
    }
}

