/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.camel.CamelContext;
import org.apache.camel.Producer;
import org.apache.camel.openapi.RestOpenApiSupport;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestProducerFactory;
import org.apache.camel.support.CamelContextHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiRestProducerFactory
implements RestProducerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiRestProducerFactory.class);

    public Producer createProducer(CamelContext camelContext, String host, String verb, String basePath, String uriTemplate, String queryParameters, String consumes, String produces, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        OpenAPI openApi;
        Operation operation;
        Object path;
        String apiDoc = (String)parameters.get("apiDoc");
        if (apiDoc == null) {
            throw new IllegalArgumentException("OpenApi api-doc must be configured using the apiDoc option");
        }
        Object object = path = uriTemplate != null ? uriTemplate : basePath;
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if ((operation = this.getOpenApiOperation(openApi = this.loadOpenApiModel(apiDoc), verb, (String)path)) == null) {
            throw new IllegalArgumentException("OpenApi api-doc does not contain operation for " + verb + ":" + (String)path);
        }
        if (queryParameters != null) {
            for (Parameter param : operation.getParameters()) {
                String key;
                String token;
                boolean hasQuery;
                if (!"query".equals(param.getIn()) || !Boolean.TRUE.equals(param.getRequired()) || (hasQuery = queryParameters.contains(token = (key = param.getName()) + "="))) continue;
                throw new IllegalArgumentException("OpenApi api-doc does not contain query parameter " + key + " for " + verb + ":" + (String)path);
            }
        }
        String componentName = (String)parameters.get("componentName");
        return this.createHttpProducer(camelContext, openApi, operation, host, verb, (String)path, queryParameters, produces, consumes, componentName, parameters);
    }

    OpenAPI loadOpenApiModel(String apiDoc) throws Exception {
        OpenAPIParser openApiParser = new OpenAPIParser();
        SwaggerParseResult openApi = openApiParser.readLocation(apiDoc, null, null);
        if (openApi != null && openApi.getOpenAPI() != null) {
            return openApi.getOpenAPI();
        }
        throw new IllegalArgumentException("The given OpenApi specification could not be loaded from `" + apiDoc + "`.");
    }

    private Operation getOpenApiOperation(OpenAPI openApi, String verb, String path) {
        PathItem modelPath;
        String basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
        if (basePath != null && path.startsWith(basePath)) {
            path = path.substring(basePath.length());
        }
        if ((modelPath = (PathItem)openApi.getPaths().get((Object)path)) == null) {
            return null;
        }
        Operation op = null;
        PathItem.HttpMethod method = PathItem.HttpMethod.valueOf((String)verb.toUpperCase());
        if (method != null) {
            return (Operation)modelPath.readOperationsMap().get(method);
        }
        return op;
    }

    private Producer createHttpProducer(CamelContext camelContext, OpenAPI openApi, Operation operation, String host, String verb, String path, String queryParameters, String consumes, String produces, String componentName, Map<String, Object> parameters) throws Exception {
        LOG.debug("Using OpenApi operation: {} with {} {}", new Object[]{operation, verb, path});
        RestProducerFactory factory = (RestProducerFactory)parameters.remove("restProducerFactory");
        if (factory != null) {
            String uriTemplate;
            String basePath;
            LOG.debug("Using RestProducerFactory: {}", (Object)factory);
            if (produces == null) {
                StringJoiner producesBuilder = new StringJoiner(",");
                if (operation.getResponses() != null) {
                    for (ApiResponse response : operation.getResponses().values()) {
                        if (response.getContent() == null) continue;
                        for (String mediaType : response.getContent().keySet()) {
                            producesBuilder.add(mediaType);
                        }
                    }
                }
                String string = produces = producesBuilder.length() == 0 ? null : producesBuilder.toString();
            }
            if (consumes == null) {
                StringJoiner consumesBuilder = new StringJoiner(",");
                if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
                    for (String mediaType : operation.getRequestBody().getContent().keySet()) {
                        consumesBuilder.add(mediaType);
                    }
                }
                String string = consumes = consumesBuilder.length() == 0 ? null : consumesBuilder.toString();
            }
            if (host == null) {
                host = RestOpenApiSupport.getHostFromOasDocument(openApi);
                basePath = RestOpenApiSupport.getBasePathFromOasDocument(openApi);
                uriTemplate = path;
            } else {
                basePath = path;
                uriTemplate = null;
            }
            RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)camelContext, null, (String)componentName);
            return factory.createProducer(camelContext, host, verb, basePath, uriTemplate, queryParameters, consumes, produces, config, parameters);
        }
        throw new IllegalStateException("Cannot find RestProducerFactory in Registry or as a Component to use");
    }
}

