/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.olingo2.Olingo2AppWrapper;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.component.olingo2.Olingo2Endpoint;
import org.apache.camel.component.olingo2.api.Olingo2App;
import org.apache.camel.component.olingo2.api.impl.Olingo2AppImpl;
import org.apache.camel.component.olingo2.internal.Olingo2ApiCollection;
import org.apache.camel.component.olingo2.internal.Olingo2ApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;

@Component(value="olingo2")
public class Olingo2Component
extends AbstractApiComponent<Olingo2ApiName, Olingo2Configuration, Olingo2ApiCollection>
implements SSLContextParametersAware {
    @Metadata
    Olingo2Configuration configuration;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;
    private Olingo2AppWrapper apiProxy;

    public Olingo2Component() {
        super(Olingo2ApiName.class, (ApiCollection)Olingo2ApiCollection.getCollection());
    }

    public Olingo2Component(CamelContext context) {
        super(context, Olingo2ApiName.class, (ApiCollection)Olingo2ApiCollection.getCollection());
    }

    protected Olingo2ApiName getApiName(String apiNameStr) {
        return (Olingo2ApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(Olingo2ApiName.class, (Object)apiNameStr));
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining.startsWith("DEFAULT/")) {
            remaining = remaining.substring(8);
        }
        String[] pathSegments = remaining.split("/", -1);
        String methodName = pathSegments[0];
        if (pathSegments.length > 1) {
            StringBuilder resourcePath = new StringBuilder();
            for (int i = 1; i < pathSegments.length; ++i) {
                resourcePath.append(pathSegments[i]);
                if (i >= pathSegments.length - 1) continue;
                resourcePath.append('/');
            }
            parameters.put("resourcePath", resourcePath.toString());
        }
        Olingo2Configuration endpointConfiguration = (Olingo2Configuration)this.createEndpointConfiguration(Olingo2ApiName.DEFAULT);
        Endpoint endpoint = this.createEndpoint(uri, methodName, Olingo2ApiName.DEFAULT, endpointConfiguration);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    protected Endpoint createEndpoint(String uri, String methodName, Olingo2ApiName apiName, Olingo2Configuration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new Olingo2Endpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public void setConfiguration(Olingo2Configuration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public Olingo2Configuration getConfiguration() {
        return (Olingo2Configuration)super.getConfiguration();
    }

    public Olingo2AppWrapper createApiProxy(Olingo2Configuration endpointConfiguration) {
        Olingo2AppWrapper result;
        if (endpointConfiguration.equals(this.getConfiguration())) {
            this.lock.lock();
            try {
                if (this.apiProxy == null) {
                    this.apiProxy = this.createOlingo2App(this.getConfiguration());
                }
            }
            finally {
                this.lock.unlock();
            }
            result = this.apiProxy;
        } else {
            result = this.createOlingo2App(endpointConfiguration);
        }
        return result;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    private Olingo2AppWrapper createOlingo2App(Olingo2Configuration configuration) {
        HttpAsyncClientBuilder clientBuilder = configuration.getHttpAsyncClientBuilder();
        if (clientBuilder == null) {
            HttpAsyncClientBuilder asyncClientBuilder = HttpAsyncClientBuilder.create();
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            requestConfigBuilder.setConnectTimeout(configuration.getConnectTimeout());
            requestConfigBuilder.setSocketTimeout(configuration.getSocketTimeout());
            HttpHost proxy = configuration.getProxy();
            if (proxy != null) {
                requestConfigBuilder.setProxy(proxy);
            }
            asyncClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            SSLContextParameters sslContextParameters = configuration.getSslContextParameters();
            if (sslContextParameters == null) {
                sslContextParameters = this.retrieveGlobalSslContextParameters();
            }
            if (sslContextParameters == null) {
                sslContextParameters = new SSLContextParameters();
            }
            try {
                asyncClientBuilder.setSSLContext(sslContextParameters.createSSLContext(this.getCamelContext()));
            }
            catch (IOException | GeneralSecurityException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            clientBuilder = asyncClientBuilder;
        }
        Olingo2AppImpl olingo2App = clientBuilder == null || clientBuilder instanceof HttpAsyncClientBuilder ? new Olingo2AppImpl(configuration.getServiceUri(), clientBuilder) : new Olingo2AppImpl(configuration.getServiceUri(), (HttpClientBuilder)clientBuilder);
        this.apiProxy = new Olingo2AppWrapper((Olingo2App)olingo2App);
        this.apiProxy.getOlingo2App().setContentType(configuration.getContentType());
        this.apiProxy.getOlingo2App().setHttpHeaders(configuration.getHttpHeaders());
        this.apiProxy.getOlingo2App().setEntityProviderReadProperties(configuration.getEntityProviderReadProperties());
        this.apiProxy.getOlingo2App().setEntityProviderWriteProperties(configuration.getEntityProviderWriteProperties());
        return this.apiProxy;
    }

    public void closeApiProxy(Olingo2AppWrapper apiProxy) {
        if (this.apiProxy != apiProxy) {
            apiProxy.close();
        }
    }

    protected void doStop() throws Exception {
        if (this.apiProxy != null) {
            this.apiProxy.close();
        }
    }
}

