/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedSingletonObjectPool<T>
implements ObjectPool<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSingletonObjectPool.class);
    private final Lock lock = new ReentrantLock();
    private final PooledObjectFactory<T> factory;
    private volatile PooledObject<T> t;

    public SharedSingletonObjectPool(PooledObjectFactory<T> factory) {
        this.factory = factory;
    }

    public void addObject() throws Exception {
    }

    public T borrowObject() throws Exception {
        this.lock.lock();
        try {
            if (this.t != null && !this.factory.validateObject(this.t)) {
                this.invalidateObject(this.t.getObject());
                LOG.info("Recreating new connection as current connection is invalid: {}", this.t);
                this.t = null;
            }
            if (this.t == null) {
                this.t = this.factory.makeObject();
            }
            Object object = this.t.getObject();
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() throws Exception {
        this.t = null;
    }

    public void close() {
        this.t = null;
    }

    public int getNumActive() {
        return 1;
    }

    public int getNumIdle() {
        return 0;
    }

    public void invalidateObject(T obj) throws Exception {
        this.t = null;
    }

    public void returnObject(T obj) throws Exception {
    }
}

