/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.ChannelHandlerFactories;
import org.apache.camel.component.netty.ChannelHandlerFactory;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponent;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
@Configurer
public class NettyConfiguration
extends NettyServerBootstrapConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfiguration.class);
    private transient List<ChannelHandler> encodersList = new ArrayList<ChannelHandler>();
    private transient List<ChannelHandler> decodersList = new ArrayList<ChannelHandler>();
    @UriParam(label="producer", description="Allows to use a timeout for the Netty producer when calling a remote server. By default no timeout is in use. The value is in milli seconds, so eg 30000 is 30 seconds. The requestTimeout is using Netty's ReadTimeoutHandler to trigger the timeout.")
    private long requestTimeout;
    @UriParam(defaultValue="true", description="Setting to set endpoint as one-way (false) or request-response (true)")
    private boolean sync = true;
    @UriParam(label="codec", description="Only used for TCP. If no codec is specified, you can use this flag to indicate a text line based codec; if not specified or the value is false, then Object Serialization is assumed over TCP - however only Strings are allowed to be serialized by default.")
    private boolean textline;
    @UriParam(label="codec", defaultValue="LINE", description="The delimiter to use for the textline codec. Possible values are LINE and NULL.")
    private TextLineDelimiter delimiter = TextLineDelimiter.LINE;
    @UriParam(label="codec", defaultValue="true", description="Whether or not to auto append missing end delimiter when sending using the textline codec.")
    private boolean autoAppendDelimiter = true;
    @UriParam(label="codec", defaultValue="1024", description="The max line length to use for the textline codec.")
    private int decoderMaxLineLength = 1024;
    @UriParam(label="codec", description="The encoding (a charset name) to use for the textline codec. If not provided, Camel will use the JVM default Charset.")
    private String encoding;
    @UriParam(label="codec", description="A list of encoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.")
    private String encoders;
    @UriParam(label="codec", description="A list of decoders to be used. You can use a String which have values separated by comma, and have the values be looked up in the Registry. Just remember to prefix the value with # so Camel knows it should lookup.")
    private String decoders;
    @UriParam(label="common,security", description="To enable/disable hostname verification on SSLEngine")
    private boolean hostnameVerification;
    @UriParam(label="common", description="Whether or not to disconnect(close) from Netty Channel right after use.")
    private boolean disconnect;
    @UriParam(label="producer,advanced", defaultValue="true", description="Channels can be lazily created to avoid exceptions, if the remote server is not up and running when the Camel producer is started.")
    private boolean lazyChannelCreation = true;
    @UriParam(label="advanced", description="Only used for TCP. You can transfer the exchange over the wire instead of just the body. The following fields are transferred: In body, Out body, fault body, In headers, Out headers, fault headers, exchange properties, exchange exception. This requires that the objects are serializable. Camel will exclude any non-serializable objects and log it at WARN level.")
    private boolean transferExchange;
    @UriParam(label="advanced", description="Only used for TCP when transferExchange is true. When set to true, serializable objects in headers and properties will be added to the exchange. Otherwise Camel will exclude any non-serializable objects and log it at WARN level.")
    private boolean allowSerializedHeaders;
    @UriParam(label="consumer,advanced", defaultValue="true", description="If sync is enabled then this option dictates NettyConsumer if it should disconnect where there is no reply to send back.")
    private boolean disconnectOnNoReply = true;
    @UriParam(label="consumer,advanced", defaultValue="WARN", description="If sync is enabled this option dictates NettyConsumer which logging level to use when logging a there is no reply to send back.")
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    @UriParam(label="consumer,advanced", defaultValue="WARN", description="If the server (NettyConsumer) catches an exception then its logged using this logging level.")
    private LoggingLevel serverExceptionCaughtLogLevel = LoggingLevel.WARN;
    @UriParam(label="consumer,advanced", defaultValue="DEBUG", description="If the server (NettyConsumer) catches an java.nio.channels.ClosedChannelException then its logged using this logging level. This is used to avoid logging the closed channel exceptions, as clients can disconnect abruptly and then cause a flood of closed exceptions in the Netty server.")
    private LoggingLevel serverClosedChannelExceptionCaughtLogLevel = LoggingLevel.DEBUG;
    @UriParam(label="codec", defaultValue="true", description="The netty component installs a default codec if both, encoder/decoder is null and textline is false. Setting allowDefaultCodec to false prevents the netty component from installing a default codec as the first element in the filter chain.")
    private boolean allowDefaultCodec = true;
    @UriParam(label="producer,advanced", description="To use a custom ClientInitializerFactory")
    private ClientInitializerFactory clientInitializerFactory;
    @UriParam(label="consumer,advanced", defaultValue="true", description="Whether to use ordered thread pool, to ensure events are processed orderly on the same channel.")
    private boolean usingExecutorService = true;
    @UriParam(label="producer,advanced", defaultValue="-1", description="Sets the cap on the number of objects that can be allocated by the pool (checked out to clients, or idle awaiting checkout) at a given time. Use a negative value for no limit. Be careful to not set this value too low (such as 1) as the pool must have space to create a producer such as when performing retries. Be mindful that the option producerPoolBlockWhenExhausted is default true, and the pool will then block when there is no space, which can lead to the application to hang.")
    private int producerPoolMaxTotal = -1;
    @UriParam(label="producer,advanced", description="Sets the minimum number of instances allowed in the producer pool before the evictor thread (if active) spawns new objects.")
    private int producerPoolMinIdle;
    @UriParam(label="producer,advanced", defaultValue="100", description="Sets the cap on the number of idle instances in the pool.")
    private int producerPoolMaxIdle = 100;
    @UriParam(label="producer,advanced", defaultValue="300000", description="Sets the minimum amount of time (value in millis) an object may sit idle in the pool before it is eligible for eviction by the idle object evictor.")
    private long producerPoolMinEvictableIdle = 300000L;
    @UriParam(label="producer,advanced", defaultValue="-1", description="Sets the maximum duration (value in millis) the borrowObject() method should block before throwing an exception when the pool is exhausted and producerPoolBlockWhenExhausted is true. When less than 0, the borrowObject() method may block indefinitely.")
    private long producerPoolMaxWait = -1L;
    @UriParam(label="producer,advanced", defaultValue="true", description="Sets the value for the blockWhenExhausted configuration attribute. It determines whether to block when the borrowObject() method is invoked when the pool is exhausted (the maximum number of active objects has been reached).")
    private boolean producerPoolBlockWhenExhausted = true;
    @UriParam(label="producer,advanced", defaultValue="true", description="Whether producer pool is enabled or not. Important: If you turn this off then a single shared connection is used for the producer, also if you are doing request/reply. That means there is a potential issue with interleaved responses if replies comes back out-of-order. Therefore you need to have a correlation id in both the request and reply messages so you can properly correlate the replies to the Camel callback that is responsible for continue processing the message in Camel. To do this you need to implement NettyCamelStateCorrelationManager as correlation manager and configure it via the correlationManager option. See also the correlationManager option for more details.")
    private boolean producerPoolEnabled = true;
    @UriParam(label="producer,advanced", description="This option supports connection less udp sending which is a real fire and forget. A connected udp send receive the PortUnreachableException if no one is listen on the receiving port.")
    private boolean udpConnectionlessSending;
    @UriParam(label="consumer", description="If the clientMode is true, netty consumer will connect the address as a TCP client.")
    private boolean clientMode;
    @UriParam(label="producer,advanced", description="If the useByteBuf is true, netty producer will turn the message body into ByteBuf before sending it out.")
    private boolean useByteBuf;
    @UriParam(label="advanced", description="For UDP only. If enabled the using byte array codec instead of Java serialization protocol.")
    private boolean udpByteArrayCodec;
    @UriParam(label="common", description="This option allows producers and consumers (in client mode) to reuse the same Netty Channel for the lifecycle of processing the Exchange. This is useful if you need to call a server multiple times in a Camel route and want to use the same network connection. When using this, the channel is not returned to the connection pool until the Exchange is done; or disconnected if the disconnect option is set to true. The reused Channel is stored on the Exchange as an exchange property with the key CamelNettyChannel which allows you to obtain the channel during routing and use it as well.")
    private boolean reuseChannel;
    @UriParam(label="producer,advanced", description="To use a custom correlation manager to manage how request and reply messages are mapped when using request/reply with the netty producer. This should only be used if you have a way to map requests together with replies such as if there is correlation ids in both the request and reply messages. This can be used if you want to multiplex concurrent messages on the same channel (aka connection) in netty. When doing this you must have a way to correlate the request and reply messages so you can store the right reply on the inflight Camel Exchange before its continued routed. We recommend extending the TimeoutCorrelationManagerSupport when you build custom correlation managers. This provides support for timeout and other complexities you otherwise would need to implement as well. See also the producerPoolEnabled option for more details.")
    private NettyCamelStateCorrelationManager correlationManager;

    public NettyConfiguration copy() {
        try {
            NettyConfiguration answer = (NettyConfiguration)this.clone();
            answer.setEncodersAsList(new ArrayList<ChannelHandler>(this.getEncodersAsList()));
            answer.setDecodersAsList(new ArrayList<ChannelHandler>(this.getDecodersAsList()));
            return answer;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public void validateConfiguration() {
        for (ChannelHandler encoder : this.encodersList) {
            if (encoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)encoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The encoder {} is not @Shareable or an ChannelHandlerFactory instance. The encoder cannot safely be used.", (Object)encoder);
        }
        for (ChannelHandler decoder : this.decodersList) {
            if (decoder instanceof ChannelHandlerFactory || ObjectHelper.getAnnotation((Object)decoder, ChannelHandler.Sharable.class) != null) continue;
            LOG.warn("The decoder {} is not @Shareable or an ChannelHandlerFactory instance. The decoder cannot safely be used.", (Object)decoder);
        }
        if (this.sslHandler != null) {
            boolean shareable;
            boolean factory = this.sslHandler instanceof ChannelHandlerFactory;
            boolean bl = shareable = ObjectHelper.getAnnotation((Object)this.sslHandler, ChannelHandler.Sharable.class) != null;
            if (!factory && !shareable) {
                LOG.warn("The sslHandler {} is not @Shareable or an ChannelHandlerFactory instance. The sslHandler cannot safely be used.", (Object)this.sslHandler);
            }
        }
    }

    public void parseURI(URI uri, Map<String, Object> parameters, NettyComponent component, String ... supportedProtocols) throws Exception {
        this.protocol = uri.getScheme();
        boolean found = false;
        for (String supportedProtocol : supportedProtocols) {
            if (this.protocol == null || !this.protocol.equalsIgnoreCase(supportedProtocol)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Unrecognized Netty protocol: " + this.protocol + " for uri: " + String.valueOf(uri));
        }
        this.setHost(uri.getHost());
        if (uri.getPort() != -1) {
            this.setPort(uri.getPort());
        }
        this.ssl = (Boolean)component.getAndRemoveOrResolveReferenceParameter(parameters, "ssl", Boolean.TYPE, this.ssl);
        this.sslHandler = (SslHandler)component.getAndRemoveOrResolveReferenceParameter(parameters, "sslHandler", SslHandler.class, this.sslHandler);
        this.passphrase = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "passphrase", String.class, this.passphrase);
        this.keyStoreFormat = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "keyStoreFormat", String.class, this.keyStoreFormat == null ? "JKS" : this.keyStoreFormat);
        this.securityProvider = (String)component.getAndRemoveOrResolveReferenceParameter(parameters, "securityProvider", String.class, this.securityProvider == null ? "SunX509" : this.securityProvider);
        this.keyStoreResource = this.uriRef(component, parameters, "keyStoreResource", this.keyStoreResource);
        this.trustStoreResource = this.uriRef(component, parameters, "trustStoreResource", this.trustStoreResource);
        this.clientInitializerFactory = (ClientInitializerFactory)((Object)component.getAndRemoveOrResolveReferenceParameter(parameters, "clientInitializerFactory", ClientInitializerFactory.class, (Object)this.clientInitializerFactory));
        this.serverInitializerFactory = (ServerInitializerFactory)((Object)component.getAndRemoveOrResolveReferenceParameter(parameters, "serverInitializerFactory", ServerInitializerFactory.class, (Object)this.serverInitializerFactory));
        List referencedEncoders = component.resolveAndRemoveReferenceListParameter(parameters, "encoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.encodersList, referencedEncoders, ChannelHandler.class);
        List referencedDecoders = component.resolveAndRemoveReferenceListParameter(parameters, "decoders", ChannelHandler.class, null);
        NettyConfiguration.addToHandlersList(this.decodersList, referencedDecoders, ChannelHandler.class);
        List configEncoders = EndpointHelper.resolveReferenceListParameter((CamelContext)component.getCamelContext(), (String)this.encoders, ChannelHandler.class);
        NettyConfiguration.addToHandlersList(this.encodersList, configEncoders, ChannelHandler.class);
        List configDecoders = EndpointHelper.resolveReferenceListParameter((CamelContext)component.getCamelContext(), (String)this.decoders, ChannelHandler.class);
        NettyConfiguration.addToHandlersList(this.decodersList, configDecoders, ChannelHandler.class);
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver((CamelContext)component.getCamelContext()).resolvePropertyConfigurer(this.getClass().getName(), component.getCamelContext());
        PropertyBindingSupport.build().withCamelContext(component.getCamelContext()).withTarget((Object)this).withReflection(false).withIgnoreCase(true).withConfigurer(configurer).withProperties(parameters).bind();
        this.addAdditionalOptions(PropertiesHelper.extractProperties(parameters, (String)"option."));
        if (this.encodersList.isEmpty() && this.decodersList.isEmpty()) {
            if (this.isAllowDefaultCodec()) {
                if ("udp".equalsIgnoreCase(this.protocol)) {
                    this.encodersList.add(ChannelHandlerFactories.newDatagramPacketEncoder());
                }
                if (this.isTextline()) {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encodersList.add(ChannelHandlerFactories.newStringEncoder(charset, this.protocol));
                    ByteBuf[] delimiters = this.delimiter == TextLineDelimiter.LINE ? Delimiters.lineDelimiter() : Delimiters.nulDelimiter();
                    this.decodersList.add(ChannelHandlerFactories.newDelimiterBasedFrameDecoder(this.decoderMaxLineLength, delimiters, this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newStringDecoder(charset, this.protocol));
                    LOG.debug("Using textline encoders and decoders with charset: {}, delimiter: {} and decoderMaxLineLength: {}", new Object[]{charset, this.delimiter, this.decoderMaxLineLength});
                } else if ("udp".equalsIgnoreCase(this.protocol) && this.isUdpByteArrayCodec()) {
                    this.encodersList.add(ChannelHandlerFactories.newByteArrayEncoder(this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newByteArrayDecoder(this.protocol));
                } else {
                    Charset charset = this.getEncoding() != null ? Charset.forName(this.getEncoding()) : CharsetUtil.UTF_8;
                    this.encodersList.add(ChannelHandlerFactories.newStringEncoder(charset, this.protocol));
                    this.decodersList.add(ChannelHandlerFactories.newStringDecoder(charset, this.protocol));
                }
                if ("udp".equalsIgnoreCase(this.protocol)) {
                    this.decodersList.add(ChannelHandlerFactories.newDatagramPacketDecoder());
                }
            } else {
                LOG.debug("No encoders and decoders will be used");
            }
        } else {
            LOG.debug("Using configured encoders and/or decoders");
        }
    }

    private String uriRef(NettyComponent component, Map<String, Object> parameters, String key, String defaultValue) {
        Object value = parameters.remove(key);
        if (value == null) {
            value = defaultValue;
        } else if (value instanceof String && EndpointHelper.isReferenceParameter((String)((String)value))) {
            String name = ((String)value).replace("#", "");
            value = CamelContextHelper.mandatoryLookup((CamelContext)component.getCamelContext(), (String)name);
        }
        if (value instanceof File) {
            return "file:" + value.toString();
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public TextLineDelimiter getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(TextLineDelimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isAutoAppendDelimiter() {
        return this.autoAppendDelimiter;
    }

    public void setAutoAppendDelimiter(boolean autoAppendDelimiter) {
        this.autoAppendDelimiter = autoAppendDelimiter;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public List<ChannelHandler> getDecodersAsList() {
        return this.decodersList;
    }

    public void setDecodersAsList(List<ChannelHandler> decoders) {
        this.decodersList = decoders;
    }

    public void setDecoders(List<ChannelHandler> decoders) {
        this.decodersList = decoders;
    }

    public void setDecoders(String decoders) {
        this.decoders = decoders;
    }

    public String getDecoders() {
        return this.decoders;
    }

    public List<ChannelHandler> getEncodersAsList() {
        return this.encodersList;
    }

    public void setEncodersAsList(List<ChannelHandler> encoders) {
        this.encodersList = encoders;
    }

    public void setEncoders(List<ChannelHandler> encoders) {
        this.encodersList = encoders;
    }

    public void setEncoders(String encoders) {
        this.encoders = encoders;
    }

    public String getEncoders() {
        return this.encoders;
    }

    public void addEncoder(ChannelHandler encoder) {
        if (!this.encodersList.contains(encoder)) {
            this.encodersList.add(encoder);
        }
    }

    public void addDecoder(ChannelHandler decoder) {
        if (!this.decodersList.contains(decoder)) {
            this.decodersList.add(decoder);
        }
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isLazyChannelCreation() {
        return this.lazyChannelCreation;
    }

    public void setLazyChannelCreation(boolean lazyChannelCreation) {
        this.lazyChannelCreation = lazyChannelCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public boolean isAllowSerializedHeaders() {
        return this.allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public LoggingLevel getServerExceptionCaughtLogLevel() {
        return this.serverExceptionCaughtLogLevel;
    }

    public void setServerExceptionCaughtLogLevel(LoggingLevel serverExceptionCaughtLogLevel) {
        this.serverExceptionCaughtLogLevel = serverExceptionCaughtLogLevel;
    }

    public LoggingLevel getServerClosedChannelExceptionCaughtLogLevel() {
        return this.serverClosedChannelExceptionCaughtLogLevel;
    }

    public void setServerClosedChannelExceptionCaughtLogLevel(LoggingLevel serverClosedChannelExceptionCaughtLogLevel) {
        this.serverClosedChannelExceptionCaughtLogLevel = serverClosedChannelExceptionCaughtLogLevel;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    @Deprecated
    public void setClientPipelineFactory(ClientInitializerFactory clientPipelineFactory) {
        this.clientInitializerFactory = clientPipelineFactory;
    }

    @Deprecated
    public ClientInitializerFactory getClientPipelineFactory() {
        return this.clientInitializerFactory;
    }

    public ClientInitializerFactory getClientInitializerFactory() {
        return this.clientInitializerFactory;
    }

    public void setClientInitializerFactory(ClientInitializerFactory clientInitializerFactory) {
        this.clientInitializerFactory = clientInitializerFactory;
    }

    public boolean isUsingExecutorService() {
        return this.usingExecutorService;
    }

    public void setUsingExecutorService(boolean usingExecutorService) {
        this.usingExecutorService = usingExecutorService;
    }

    public int getProducerPoolMaxTotal() {
        return this.producerPoolMaxTotal;
    }

    public void setProducerPoolMaxTotal(int producerPoolMaxTotal) {
        this.producerPoolMaxTotal = producerPoolMaxTotal;
    }

    public int getProducerPoolMinIdle() {
        return this.producerPoolMinIdle;
    }

    public void setProducerPoolMinIdle(int producerPoolMinIdle) {
        this.producerPoolMinIdle = producerPoolMinIdle;
    }

    public int getProducerPoolMaxIdle() {
        return this.producerPoolMaxIdle;
    }

    public void setProducerPoolMaxIdle(int producerPoolMaxIdle) {
        this.producerPoolMaxIdle = producerPoolMaxIdle;
    }

    public long getProducerPoolMinEvictableIdle() {
        return this.producerPoolMinEvictableIdle;
    }

    public void setProducerPoolMinEvictableIdle(long producerPoolMinEvictableIdle) {
        this.producerPoolMinEvictableIdle = producerPoolMinEvictableIdle;
    }

    public long getProducerPoolMaxWait() {
        return this.producerPoolMaxWait;
    }

    public void setProducerPoolMaxWait(long producerPoolMaxWait) {
        this.producerPoolMaxWait = producerPoolMaxWait;
    }

    public boolean isProducerPoolBlockWhenExhausted() {
        return this.producerPoolBlockWhenExhausted;
    }

    public void setProducerPoolBlockWhenExhausted(boolean producerPoolBlockWhenExhausted) {
        this.producerPoolBlockWhenExhausted = producerPoolBlockWhenExhausted;
    }

    public boolean isProducerPoolEnabled() {
        return this.producerPoolEnabled;
    }

    public void setProducerPoolEnabled(boolean producerPoolEnabled) {
        this.producerPoolEnabled = producerPoolEnabled;
    }

    public boolean isUdpConnectionlessSending() {
        return this.udpConnectionlessSending;
    }

    public void setUdpConnectionlessSending(boolean udpConnectionlessSending) {
        this.udpConnectionlessSending = udpConnectionlessSending;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public boolean isUseByteBuf() {
        return this.useByteBuf;
    }

    public void setUseByteBuf(boolean useByteBuf) {
        this.useByteBuf = useByteBuf;
    }

    public boolean isUdpByteArrayCodec() {
        return this.udpByteArrayCodec;
    }

    public void setUdpByteArrayCodec(boolean udpByteArrayCodec) {
        this.udpByteArrayCodec = udpByteArrayCodec;
    }

    public boolean isReuseChannel() {
        return this.reuseChannel;
    }

    public void setReuseChannel(boolean reuseChannel) {
        this.reuseChannel = reuseChannel;
    }

    public NettyCamelStateCorrelationManager getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(NettyCamelStateCorrelationManager correlationManager) {
        this.correlationManager = correlationManager;
    }

    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    private static <T> void addToHandlersList(List<T> configured, List<T> handlers, Class<T> handlerType) {
        if (handlers != null) {
            for (T handler : handlers) {
                if (!handlerType.isInstance(handler)) continue;
                configured.add(handler);
            }
        }
    }
}

