/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;

public class OutboundStreamHttpRequest
extends DefaultHttpRequest
implements ChunkedInput<HttpContent> {
    private final HttpChunkedInput input;

    public OutboundStreamHttpRequest(InputStream in, DefaultHttpRequest request) {
        super(request.protocolVersion(), request.method(), request.uri());
        this.input = new HttpChunkedInput((ChunkedInput)new ChunkedStream(in));
    }

    public DefaultHttpRequest getRequest() {
        return new DefaultHttpRequest(this.protocolVersion(), this.method(), this.uri(), this.headers());
    }

    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    public void close() throws Exception {
        this.input.close();
    }

    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.input.readChunk(channelHandlerContext);
    }

    public HttpContent readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        return this.input.readChunk(byteBufAllocator);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

