/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.support.processor.ThroughputLogger;

@org.apache.camel.spi.annotations.Component(value="mock")
public class MockComponent
extends DefaultComponent {
    @Metadata(label="producer", description="To turn on logging when the mock receives an incoming message. This will log only one time at INFO level for the incoming message. For more detailed logging, then set the logger to DEBUG level for the org.apache.camel.component.mock.MockEndpoint class.")
    private boolean log;
    @Metadata(label="advanced", autowired=true, description="To use a custom ExchangeFormatter to format the Exchange into a String suitable for logging.")
    private ExchangeFormatter exchangeFormatter;

    public MockComponent() {
    }

    public MockComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MockEndpoint endpoint = new MockEndpoint(uri, (Component)this);
        endpoint.setName(remaining);
        endpoint.setLog(this.log);
        Integer value = (Integer)this.getAndRemoveParameter(parameters, "reportGroup", Integer.class);
        if (value != null) {
            ThroughputLogger reporter = new ThroughputLogger(new CamelLogger("org.apache.camel.component.mock:" + remaining), value);
            endpoint.setReporter((Processor)reporter);
            endpoint.setReportGroup(value);
        }
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doInit() throws Exception {
        if (this.exchangeFormatter == null) {
            DefaultExchangeFormatter def = new DefaultExchangeFormatter();
            def.setShowExchangeId(true);
            def.setShowExchangePattern(false);
            def.setSkipBodyLineSeparator(true);
            def.setShowBody(true);
            def.setShowBodyType(true);
            def.setStyle(DefaultExchangeFormatter.OutputStyle.Default);
            def.setMaxChars(10000);
            this.exchangeFormatter = def;
        }
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public ExchangeFormatter getExchangeFormatter() {
        return this.exchangeFormatter;
    }

    public void setExchangeFormatter(ExchangeFormatter exchangeFormatter) {
        this.exchangeFormatter = exchangeFormatter;
    }
}

