/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Set;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MicrometerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MicrometerUtils.class);

    public static Meter.Type getByName(String meterName) {
        switch (meterName) {
            case "summary": {
                return Meter.Type.DISTRIBUTION_SUMMARY;
            }
            case "counter": {
                return Meter.Type.COUNTER;
            }
            case "timer": {
                return Meter.Type.TIMER;
            }
        }
        throw new RuntimeCamelException("Unsupported meter type " + meterName);
    }

    public static String getName(Meter.Type type) {
        switch (type) {
            case DISTRIBUTION_SUMMARY: {
                return "summary";
            }
            case COUNTER: {
                return "counter";
            }
            case TIMER: {
                return "timer";
            }
        }
        throw new RuntimeCamelException("Unsupported meter type " + type);
    }

    public static MeterRegistry getOrCreateMeterRegistry(Registry camelRegistry, String name) {
        MeterRegistry result = MicrometerUtils.getMeterRegistryFromCamelRegistry(camelRegistry, name);
        if (result == null) {
            LOG.debug("Creating new MeterRegistry: {}", (Object)name);
            result = MicrometerUtils.createMeterRegistry();
            camelRegistry.bind(name, (Object)result);
        } else {
            LOG.debug("Using existing MeterRegistry: {}", (Object)name);
        }
        return result;
    }

    public static MeterRegistry getMeterRegistryFromCamelRegistry(Registry camelRegistry, String registryName) {
        MeterRegistry registry = (MeterRegistry)camelRegistry.lookupByNameAndType(registryName, MeterRegistry.class);
        if (registry != null) {
            return registry;
        }
        Set registries = camelRegistry.findByType(MeterRegistry.class);
        if (registries.size() == 1) {
            return (MeterRegistry)registries.iterator().next();
        }
        return null;
    }

    public static MeterRegistry createMeterRegistry() {
        return new SimpleMeterRegistry();
    }
}

