/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedChoiceMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;

@ManagedResource(description="Managed Choice")
public class ManagedChoice
extends ManagedProcessor
implements ManagedChoiceMBean {
    private final ChoiceProcessor processor;

    public ManagedChoice(CamelContext context, ChoiceProcessor processor, ProcessorDefinition<?> definition) {
        super(context, (Processor)processor, definition);
        this.processor = processor;
    }

    public ChoiceDefinition getDefinition() {
        return (ChoiceDefinition)super.getDefinition();
    }

    @Override
    public void reset() {
        this.processor.reset();
        super.reset();
    }

    @Override
    public Boolean getSupportExtendedInformation() {
        return true;
    }

    public TabularData choiceStatistics() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.choiceTabularType());
            List whens = this.getDefinition().getWhenClauses();
            List filters = this.processor.getFilters();
            for (int i = 0; i < filters.size(); ++i) {
                WhenDefinition when = (WhenDefinition)whens.get(i);
                FilterProcessor filter = (FilterProcessor)filters.get(i);
                CompositeType ct = CamelOpenMBeanTypes.choiceCompositeType();
                String predicate = when.getExpression().getExpression();
                String language = when.getExpression().getLanguage();
                Long matches = filter.getFilteredCount();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"predicate", "language", "matches"}, new Object[]{predicate, language, matches});
                answer.put(data);
            }
            if (this.getDefinition().getOtherwise() != null) {
                CompositeType ct = CamelOpenMBeanTypes.choiceCompositeType();
                String predicate = "otherwise";
                String language = "";
                Long matches = this.processor.getNotFilteredCount();
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"predicate", "language", "matches"}, new Object[]{predicate, language, matches});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

