/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.api.management.mbean;

import java.util.List;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.spi.BacklogTracerEventMessage;

public interface ManagedBacklogTracerMBean {
    @ManagedAttribute(description="Camel ID")
    public String getCamelId();

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName();

    @ManagedAttribute(description="Is tracing standby")
    public boolean isStandby();

    @ManagedAttribute(description="Is tracing enabled")
    public boolean isEnabled();

    @ManagedAttribute(description="Is tracing enabled")
    public void setEnabled(boolean var1);

    @ManagedAttribute(description="Number of maximum traced messages in total to keep in the backlog (FIFO queue)")
    public int getBacklogSize();

    @ManagedAttribute(description="Number of maximum traced messages in total to keep in the backlog (FIFO queue)")
    public void setBacklogSize(int var1);

    @ManagedAttribute(description="Whether to remove traced message from backlog when dumping trace messages")
    public boolean isRemoveOnDump();

    @ManagedAttribute(description="Whether to remove traced message from backlog when dumping trace messages")
    public void setRemoveOnDump(boolean var1);

    @ManagedAttribute(description="To filter tracing by nodes (pattern)")
    public void setTracePattern(String var1);

    @ManagedAttribute(description="To filter tracing by nodes (pattern)")
    public String getTracePattern();

    @ManagedAttribute(description="To filter tracing by predicate (uses simple language by default)")
    public void setTraceFilter(String var1);

    @ManagedAttribute(description="To filter tracing by predicate (uses simple language by default)")
    public String getTraceFilter();

    @ManagedAttribute(description="Number of total traced messages")
    public long getTraceCounter();

    @ManagedOperation(description="Resets the trace counter")
    public void resetTraceCounter();

    @ManagedAttribute(description="Number of traced messages in the backlog")
    public long getQueueSize();

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public int getBodyMaxChars();

    @ManagedAttribute(description="Number of maximum chars in the message body in the trace message. Use zero or negative value to have unlimited size.")
    public void setBodyMaxChars(int var1);

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public boolean isBodyIncludeStreams();

    @ManagedAttribute(description="Whether to include stream based message body in the trace message.")
    public void setBodyIncludeStreams(boolean var1);

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public boolean isBodyIncludeFiles();

    @ManagedAttribute(description="Whether to include file based message body in the trace message.")
    public void setBodyIncludeFiles(boolean var1);

    @ManagedAttribute(description="Whether to include exchange properties in the trace message.")
    public boolean isIncludeExchangeProperties();

    @ManagedAttribute(description="Whether to include exchange properties in the trace message.")
    public void setIncludeExchangeProperties(boolean var1);

    @ManagedAttribute(description="Whether to include exchange variables in the trace message.")
    public boolean isIncludeExchangeVariables();

    @ManagedAttribute(description="Whether to include exchange variables in the trace message.")
    public void setIncludeExchangeVariables(boolean var1);

    @ManagedAttribute(description="Whether tracing routes created from Rest DSL.")
    public boolean isTraceRests();

    @ManagedAttribute(description="Whether tracing routes created from route templates or kamelets.")
    public boolean isTraceTemplates();

    @ManagedOperation(description="Dumps the traced messages for the given node or route")
    public List<BacklogTracerEventMessage> dumpTracedMessages(String var1);

    @ManagedOperation(description="Dumps the traced messages for the given node or route in XML format")
    public String dumpTracedMessagesAsXml(String var1);

    @ManagedOperation(description="Dumps the traced messages for the given node or route in JSon format")
    public String dumpTracedMessagesAsJSon(String var1);

    @ManagedOperation(description="Dumps all the traced messages")
    public List<BacklogTracerEventMessage> dumpAllTracedMessages();

    @ManagedOperation(description="Dumps latest completed exchange message history")
    public List<BacklogTracerEventMessage> dumpLatestMessageHistory();

    @ManagedOperation(description="Dumps all the traced messages in XML format")
    public String dumpAllTracedMessagesAsXml();

    @ManagedOperation(description="Dumps all the traced messages in JSon format")
    public String dumpAllTracedMessagesAsJSon();

    @ManagedOperation(description="Dumps latest completed exchange message history in XML format")
    public String dumpLatestMessageHistoryAsXml();

    @ManagedOperation(description="Dumps latest completed exchange message history in JSon format")
    public String dumpLatestMessageHistoryAsJSon();

    @ManagedOperation(description="Clears the backlog")
    public void clear();
}

