/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.component.knative.http.KnativeHttpServiceOptions;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public class KnativeOidcServiceOptions
implements KnativeHttpServiceOptions {
    private static final String PROPERTY_PREFIX = "camel.knative.service.oidc.";
    private CamelContext camelContext;
    private boolean oidcEnabled;
    private String oidcTokenPath;
    private String oidcToken;
    private boolean cacheTokens = true;

    public KnativeOidcServiceOptions() {
    }

    public KnativeOidcServiceOptions(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.configureOptions(camelContext);
    }

    public void configureOptions() {
        if (this.camelContext != null) {
            this.configureOptions(this.camelContext);
        }
    }

    public void configureOptions(CamelContext camelContext) {
        PropertiesComponent propertiesComponent = camelContext.getPropertiesComponent();
        boolean oidcEnabled = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.service.oidc.enabled").orElse("false"));
        this.setOidcEnabled(oidcEnabled);
        if (oidcEnabled) {
            Optional oidcTokenPath = propertiesComponent.resolveProperty("camel.knative.service.oidc.token.path");
            oidcTokenPath.ifPresent(token -> {
                this.oidcTokenPath = token;
            });
            boolean cacheTokens = Boolean.parseBoolean(propertiesComponent.resolveProperty("camel.knative.service.oidc.cache.tokens").orElse("true"));
            this.setCacheTokens(cacheTokens);
        }
    }

    public String retrieveOidcToken() {
        if (this.oidcToken == null || !this.cacheTokens) {
            try {
                this.oidcToken = IOHelper.loadText((InputStream)ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.oidcTokenPath)).trim();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.oidcToken;
    }

    public String renewOidcToken() {
        this.oidcToken = null;
        return this.retrieveOidcToken();
    }

    public void setOidcEnabled(boolean oidcEnabled) {
        this.oidcEnabled = oidcEnabled;
    }

    public boolean isOidcEnabled() {
        return this.oidcEnabled;
    }

    public void setCacheTokens(boolean cacheTokens) {
        this.cacheTokens = cacheTokens;
    }

    public boolean isCacheTokens() {
        return this.cacheTokens;
    }

    public void setOidcTokenPath(String oidcTokenPath) {
        this.oidcTokenPath = oidcTokenPath;
    }

    public String getOidcTokenPath() {
        return this.oidcTokenPath;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.configureOptions();
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }
}

