/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jte;

import gg.jte.CodeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;

public class JteCodeResolver
implements CodeResolver {
    private final CamelContext camelContext;
    private final Map<String, String> headerTemplates = new ConcurrentHashMap<String, String>();
    private final Map<String, String> pathMappings = new ConcurrentHashMap<String, String>();

    public JteCodeResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void addTemplateFromHeader(String exchangeId, String template) {
        if (exchangeId != null && template != null) {
            this.headerTemplates.put(exchangeId, template);
        }
    }

    public void addPathMapping(String name, String uri) {
        if (name != null && uri != null) {
            this.pathMappings.put(name, uri);
        }
    }

    public String resolve(String name) {
        String answer = this.headerTemplates.remove(name);
        if (answer == null) {
            Object key = this.pathMappings.remove(name);
            key = key != null ? name + ":" + (String)key : name;
            try {
                InputStream is = ResourceHelper.resolveResourceAsInputStream((CamelContext)this.camelContext, (String)key);
                if (is != null) {
                    answer = IOHelper.loadText((InputStream)is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return answer;
    }

    public long getLastModified(String name) {
        return 0L;
    }
}

