/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonata;

import com.dashjoin.jsonata.Jsonata;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jsonata.JsonataComponent;
import org.apache.camel.component.jsonata.JsonataFrameBinding;
import org.apache.camel.component.jsonata.JsonataInputOutputType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="jsonata", title="JSONata", syntax="jsonata:resourceUri", producerOnly=true, remote=false, category={Category.TRANSFORMATION})
public class JsonataEndpoint
extends ResourceEndpoint {
    private final ObjectMapper mapper = new ObjectMapper();
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType outputType;
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType inputType;
    @UriParam(label="advanced", description="To configure the Jsonata frame binding. Allows custom functions to be added.")
    private JsonataFrameBinding frameBinding;
    @UriParam
    private boolean allowTemplateFromHeader;
    @UriParam
    private boolean prettyPrint;

    public JsonataEndpoint() {
    }

    public JsonataEndpoint(String uri, JsonataComponent component, String resourceUri, JsonataFrameBinding frameBinding) {
        super(uri, (Component)component, resourceUri);
        this.frameBinding = frameBinding;
    }

    public boolean isRemote() {
        return false;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "Jsonata:" + this.getResourceUri();
    }

    public JsonataInputOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JsonataInputOutputType outputType) {
        this.outputType = outputType;
    }

    public JsonataInputOutputType getInputType() {
        return this.inputType;
    }

    public void setInputType(JsonataInputOutputType inputType) {
        this.inputType = inputType;
    }

    public void setFrameBinding(JsonataFrameBinding frameBinding) {
        this.frameBinding = frameBinding;
    }

    public JsonataFrameBinding getFrameBinding() {
        return this.frameBinding;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        Jsonata expression;
        String newResourceUri;
        Object input;
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        if (this.getInputType() == JsonataInputOutputType.JsonString) {
            InputStream inputStream = (InputStream)exchange.getIn().getBody(InputStream.class);
            input = this.mapper.readValue(inputStream, Object.class);
        } else {
            input = this.mapper.convertValue(exchange.getIn().getBody(), Object.class);
        }
        InputStream is = this.getResourceAsInputStream();
        if (this.allowTemplateFromHeader && (newResourceUri = (String)exchange.getIn().getHeader("CamelJsonataResourceUri", String.class)) != null) {
            exchange.getIn().removeHeader("CamelJsonataResourceUri");
            is = ResourceHelper.hasScheme((String)newResourceUri) ? ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)newResourceUri) : new ByteArrayInputStream(newResourceUri.getBytes());
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String spec = bufferedReader.lines().collect(Collectors.joining("\n"));
            expression = Jsonata.jsonata((String)spec);
        }
        Jsonata.Frame frame = expression.createFrame();
        if (this.frameBinding != null) {
            this.frameBinding.bindToFrame(frame);
        }
        Object outputLib = expression.evaluate(input, frame);
        String bodyAsString = this.prettyPrint ? this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString(outputLib) : this.mapper.writeValueAsString(outputLib);
        String output = this.getOutputType() == JsonataInputOutputType.JsonString ? bodyAsString : this.mapper.readTree(bodyAsString);
        ExchangeHelper.setInOutBodyPatternAware((Exchange)exchange, (Object)output);
    }
}

