/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonpatch;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jsonpatch.JsonPatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="json-patch")
public class JsonPatchComponent
extends DefaultComponent {
    @Metadata(defaultValue="true", description="Sets whether to use resource content cache or not")
    private boolean contentCache = true;
    @Metadata
    private boolean allowTemplateFromHeader;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JsonPatchEndpoint endpoint = new JsonPatchEndpoint(uri, this, remaining);
        endpoint.setContentCache(this.contentCache);
        endpoint.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    public boolean isContentCache() {
        return this.contentCache;
    }

    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }
}

