/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.User;
import java.net.URI;
import java.util.Queue;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.apache.camel.util.CastUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIssuesConsumer
extends AbstractJiraConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NewIssuesConsumer.class);
    private static final DateTimeFormatter JIRA_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm");
    private static final String NEW_ISSUES_JQL_FORMAT = "created > \"%s\" AND %s ORDER BY created DESC";
    private Issue latestIssue;
    private DateTimeZone userTimeZone;

    public NewIssuesConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.latestIssue = this.findLatestIssue();
        if (this.latestIssue != null) {
            LOG.debug("Init: Latest issue: {}", (Object)this.latestIssue.getKey());
        }
        this.userTimeZone = this.getUserTimeZone();
    }

    private String getServerTimestamp() {
        return this.latestIssue.getCreationDate().withZone(this.userTimeZone).toString(JIRA_DATE_FORMAT);
    }

    private DateTimeZone getUserTimeZone() {
        URI userURI = URI.create(this.getEndpoint().getConfiguration().getJiraUrl() + "/rest/api/latest/myself");
        User user = (User)this.getEndpoint().getClient().getUserClient().getUser(userURI).claim();
        String timezone = user.getTimezone();
        LOG.debug("Using user {} with timezone {}", (Object)user.getName(), (Object)timezone);
        return DateTimeZone.forID((String)timezone);
    }

    private Issue findLatestIssue() {
        try {
            Queue<Issue> issues = this.getIssues(this.getEndpoint().getJql() + " ORDER BY created DESC", 1);
            if (!issues.isEmpty()) {
                return issues.peek();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected int doPoll() throws Exception {
        Queue<Issue> newIssues = this.getNewIssues();
        this.processBatch(CastUtils.cast(newIssues));
        return newIssues.size();
    }

    private Queue<Issue> getNewIssues() {
        String jqlFilter = this.latestIssue != null ? String.format(NEW_ISSUES_JQL_FORMAT, this.getServerTimestamp(), this.getEndpoint().getJql()) : this.getEndpoint().getJql();
        Queue<Issue> issues = this.getIssues(jqlFilter);
        if (!issues.isEmpty()) {
            if (this.latestIssue != null) {
                issues.removeIf(i -> i.getCreationDate().isBefore((ReadableInstant)this.latestIssue.getCreationDate()) || i.getCreationDate().isEqual((ReadableInstant)this.latestIssue.getCreationDate()));
            }
            if (!issues.isEmpty()) {
                this.latestIssue = issues.peek();
                LOG.debug("Latest issue: {}", (Object)this.latestIssue.getKey());
            }
        }
        return issues;
    }
}

