/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJiraConsumer
extends ScheduledBatchPollingConsumer {
    protected static final int SEARCH_START_AT = 0;
    protected static final int SEARCH_MAX_PER_QUERY = 50;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJiraConsumer.class);
    private final JiraEndpoint endpoint;

    protected AbstractJiraConsumer(JiraEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.setDelay(endpoint.getDelay());
    }

    public JiraEndpoint getEndpoint() {
        return (JiraEndpoint)super.getEndpoint();
    }

    protected abstract int doPoll() throws Exception;

    public int poll() throws Exception {
        try {
            return this.doPoll();
        }
        catch (Exception e) {
            int code;
            RestClientException rcr = (RestClientException)((Object)ObjectHelper.getException(RestClientException.class, (Throwable)e));
            if (rcr != null && rcr.getStatusCode().isPresent() && (code = ((Integer)rcr.getStatusCode().get()).intValue()) >= 400) {
                LOG.warn("RestClientException error code: {} caused by {}. Will re-connect on next poll.", (Object)code, (Object)rcr.getMessage());
                this.getEndpoint().disconnect();
            }
            throw e;
        }
    }

    public int processBatch(Queue<Object> objects) throws Exception {
        int total = objects.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Object body = objects.poll();
            Exchange exchange = this.createExchange(true);
            exchange.getIn().setBody(body);
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getAsyncProcessor().process(exchange, EmptyAsyncCallback.get());
        }
        return total;
    }

    protected Queue<Issue> getIssues() {
        return this.getIssues(this.endpoint.getJql());
    }

    protected Queue<Issue> getIssues(String jql) {
        return this.getIssues(jql, this.endpoint.getMaxResults());
    }

    protected Queue<Issue> getIssues(String jql, int maxResults) {
        return this.getIssues(jql, 0, 50, maxResults);
    }

    protected Queue<Issue> getIssues(String jql, int start, int maxPerQuery, int maxResults) {
        LOG.debug("Start indexing current JIRA issues...");
        if (maxResults < maxPerQuery) {
            maxPerQuery = maxResults;
        }
        LinkedHashSet<Issue> issues = new LinkedHashSet<Issue>();
        while (true) {
            SearchRestClient searchRestClient = this.endpoint.getClient().getSearchClient();
            SearchResult searchResult = (SearchResult)searchRestClient.searchJql(jql, Integer.valueOf(maxPerQuery), Integer.valueOf(start), null).claim();
            for (Issue issue : searchResult.getIssues()) {
                issues.add(issue);
            }
            if (maxPerQuery >= searchResult.getTotal() || start >= searchResult.getTotal() || maxResults > 0 && issues.size() >= maxResults) break;
            start += maxPerQuery;
        }
        LOG.debug("End indexing current JIRA issues. {} issues indexed.", (Object)issues.size());
        return new LinkedList<Issue>(issues);
    }

    protected JiraRestClient client() {
        return this.endpoint.getClient();
    }
}

